/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.cfg.fixpoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.Name;

public class ReadWriteVisitor
extends BaseTreeVisitor {
    private Map<Symbol, SymbolReadWrite> symbolToUsages = new HashMap<Symbol, SymbolReadWrite>();

    public Map<Symbol, SymbolReadWrite> symbolToUsages() {
        return this.symbolToUsages;
    }

    @Override
    public void visitFunctionDef(FunctionDef functionDef) {
        Optional.ofNullable(functionDef.name().symbol()).ifPresent(symbol -> this.symbolToUsages.computeIfAbsent((Symbol)symbol, s -> new SymbolReadWrite()).isWrite = true);
    }

    @Override
    public void visitLambda(LambdaExpression pyLambdaExpressionTree) {
    }

    @Override
    public void visitName(Name name) {
        Optional.ofNullable(name.usage()).ifPresent(usage -> this.addToSymbolToUsageMap((Usage)usage, name.symbol()));
        super.visitName(name);
    }

    private void addToSymbolToUsageMap(Usage usage, Symbol symbol) {
        SymbolReadWrite symbolReadWrite = this.symbolToUsages.getOrDefault(symbol, new SymbolReadWrite());
        symbolReadWrite.addUsage(usage);
        if (!usage.isBindingUsage()) {
            symbolReadWrite.isRead = true;
        } else if (usage.kind() == Usage.Kind.COMPOUND_ASSIGNMENT_LHS) {
            symbolReadWrite.isRead = true;
            symbolReadWrite.isWrite = true;
        } else {
            symbolReadWrite.isWrite = true;
        }
        this.symbolToUsages.put(symbol, symbolReadWrite);
    }

    public static final class SymbolReadWrite {
        private boolean isRead = false;
        private boolean isWrite = false;
        private List<Usage> usages = new ArrayList<Usage>();

        public boolean isWrite() {
            return this.isWrite;
        }

        public boolean isRead() {
            return this.isRead;
        }

        public void addUsage(Usage usage) {
            this.usages.add(usage);
        }

        public List<Usage> usages() {
            return this.usages;
        }
    }
}

