/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.function.Consumer;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S1716")
public class BreakContinueOutsideLoopCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove this \"%s\" statement";
    public static final String CHECK_KEY = "S1716";
    private static final Consumer<SubscriptionContext> SUBSCRIPTION_CONTEXT_CONSUMER = ctx -> {
        Statement statement = (Statement)ctx.syntaxNode();
        for (Tree currentParent = statement.parent(); currentParent != null; currentParent = currentParent.parent()) {
            if (currentParent.is(Tree.Kind.WHILE_STMT) || currentParent.is(Tree.Kind.FOR_STMT)) {
                return;
            }
            if (!currentParent.is(Tree.Kind.CLASSDEF) && !currentParent.is(Tree.Kind.FUNCDEF)) continue;
            ctx.addIssue(statement, String.format(MESSAGE, statement.firstToken().value()));
            return;
        }
        ctx.addIssue(statement, String.format(MESSAGE, statement.firstToken().value()));
    };

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.BREAK_STMT, SUBSCRIPTION_CONTEXT_CONSUMER);
        context.registerSyntaxNodeConsumer(Tree.Kind.CONTINUE_STMT, SUBSCRIPTION_CONTEXT_CONSUMER);
    }
}

