/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5713")
public class ChildAndParentExceptionCaughtCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.EXCEPT_CLAUSE, ctx -> {
            ExceptClause exceptClause = (ExceptClause)ctx.syntaxNode();
            HashMap<ClassSymbol, List<Expression>> caughtExceptionsBySymbol = new HashMap<ClassSymbol, List<Expression>>();
            Expression exceptionExpression = exceptClause.exception();
            if (exceptionExpression == null) {
                return;
            }
            TreeUtils.flattenTuples(exceptionExpression).forEach(e -> ChildAndParentExceptionCaughtCheck.addExceptionExpression(e, caughtExceptionsBySymbol));
            ChildAndParentExceptionCaughtCheck.checkCaughtExceptions(ctx, caughtExceptionsBySymbol);
        });
    }

    private static void checkCaughtExceptions(SubscriptionContext ctx, Map<ClassSymbol, List<Expression>> caughtExceptionsBySymbol) {
        caughtExceptionsBySymbol.forEach((currentSymbol, caughtExceptionsWithSameSymbol) -> {
            PythonCheck.PreciseIssue issue;
            Expression currentException = (Expression)caughtExceptionsWithSameSymbol.get(0);
            if (caughtExceptionsWithSameSymbol.size() > 1) {
                issue = ctx.addIssue(currentException, "Remove this duplicate Exception class.");
                caughtExceptionsWithSameSymbol.stream().skip(1L).forEach(e -> issue.secondary((Tree)e, "Duplicate."));
            }
            issue = null;
            for (Map.Entry otherEntry : caughtExceptionsBySymbol.entrySet()) {
                ClassSymbol comparedSymbol = (ClassSymbol)otherEntry.getKey();
                if (currentSymbol == comparedSymbol || !currentSymbol.isOrExtends(comparedSymbol)) continue;
                if (issue == null) {
                    issue = ctx.addIssue(currentException, "Remove this redundant Exception class; it derives from another which is already caught.");
                }
                ChildAndParentExceptionCaughtCheck.addSecondaryLocations(issue, (List)otherEntry.getValue());
            }
        });
    }

    private static void addExceptionExpression(Expression exceptionExpression, Map<ClassSymbol, List<Expression>> caughtExceptionsByFQN) {
        Symbol symbol;
        if (exceptionExpression instanceof HasSymbol && (symbol = ((HasSymbol)((Object)exceptionExpression)).symbol()) != null && symbol.kind().equals((Object)Symbol.Kind.CLASS)) {
            ClassSymbol classSymbol = (ClassSymbol)symbol;
            caughtExceptionsByFQN.computeIfAbsent(classSymbol, k -> new ArrayList()).add(exceptionExpression);
        }
    }

    private static void addSecondaryLocations(PythonCheck.PreciseIssue issue, List<Expression> others) {
        for (Expression other : others) {
            issue.secondary(other, "Parent class.");
        }
    }
}

