/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S108")
public class EmptyNestedBlockCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S108";
    private static final String MESSAGE = "Either remove or fill this block of code.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STATEMENT_LIST, ctx -> {
            int to;
            StatementList statementListTree = (StatementList)ctx.syntaxNode();
            if (statementListTree.statements().stream().anyMatch(stmt -> !stmt.is(Tree.Kind.PASS_STMT))) {
                return;
            }
            Tree parent = statementListTree.parent();
            if (parent.is(Tree.Kind.FUNCDEF) || parent.is(Tree.Kind.CLASSDEF) || parent.is(Tree.Kind.EXCEPT_CLAUSE)) {
                return;
            }
            List<Token> parentTokens = TreeUtils.tokens(statementListTree.parent());
            int from = parentTokens.stream().filter(t -> t.type() == PythonTokenType.NEWLINE).findFirst().map(parentTokens::indexOf).orElseThrow(() -> new IllegalStateException(String.format("No newline token in parent of statement list at line %s", statementListTree.firstToken().line())));
            if (!EmptyNestedBlockCheck.containsComment(parentTokens.subList(from, to = parentTokens.indexOf(statementListTree.lastToken()) + 2))) {
                if (statementListTree.statements().isEmpty()) {
                    ctx.addIssue(statementListTree.firstToken(), MESSAGE);
                } else {
                    ctx.addIssue(statementListTree.statements().get(0), MESSAGE);
                }
            }
        });
    }

    private static boolean containsComment(List<Token> tokens) {
        return tokens.stream().anyMatch(t -> !t.trivia().isEmpty());
    }
}

