/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.IsExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5795")
public class IdentityComparisonWithCachedTypesCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE_IS = "Replace this \"is\" operator with \"==\"; identity operator is not reliable here.";
    private static final String MESSAGE_IS_NOT = "Replace this \"is not\" operator with \"!=\"; identity operator is not reliable here.";
    private static final Set<String> FQNS_CONSTRUCTORS_RETURNING_UNIQUE_REF = new HashSet<String>(Arrays.asList("frozenset", "bytes", "int", "float", "str", "tuple", "hash"));
    private static final Set<String> NAMES_OF_TYPES_UNSUITABLE_FOR_COMPARISON = new HashSet<String>(Arrays.asList("frozenset", "bytes", "int", "float", "tuple"));

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.IS, IdentityComparisonWithCachedTypesCheck::checkIsComparison);
    }

    private static void checkIsComparison(SubscriptionContext subscriptionContext) {
        IsExpression isExpr = (IsExpression)subscriptionContext.syntaxNode();
        if (IdentityComparisonWithCachedTypesCheck.isUnsuitableOperand(isExpr.leftOperand()) || IdentityComparisonWithCachedTypesCheck.isUnsuitableOperand(isExpr.rightOperand())) {
            Token notToken = isExpr.notToken();
            if (notToken == null) {
                subscriptionContext.addIssue(isExpr.operator(), MESSAGE_IS);
            } else {
                subscriptionContext.addIssue(isExpr.operator(), notToken, MESSAGE_IS_NOT);
            }
        }
    }

    private static boolean isUnsuitableOperand(Expression expr) {
        Symbol calleeSymbol;
        InferredType tpe = expr.type();
        if (IdentityComparisonWithCachedTypesCheck.isUnsuitableType(tpe)) {
            if (expr.is(Tree.Kind.NAME)) {
                Symbol symb = ((Name)expr).symbol();
                return symb != null && !IdentityComparisonWithCachedTypesCheck.isVariableThatCanEscape(symb);
            }
            return true;
        }
        if (expr.is(Tree.Kind.STRING_LITERAL)) {
            return true;
        }
        if (expr.is(Tree.Kind.CALL_EXPR) && (calleeSymbol = ((CallExpression)expr).calleeSymbol()) != null) {
            String calleeFqn = calleeSymbol.fullyQualifiedName();
            return FQNS_CONSTRUCTORS_RETURNING_UNIQUE_REF.contains(calleeFqn);
        }
        return false;
    }

    private static boolean isUnsuitableType(InferredType tpe) {
        return NAMES_OF_TYPES_UNSUITABLE_FOR_COMPARISON.stream().anyMatch(tpe::canOnlyBe);
    }

    private static boolean isVariableThatCanEscape(Symbol symb) {
        List<Usage> usages = symb.usages();
        if (usages.size() > 2) {
            return usages.stream().anyMatch(u -> !u.isBindingUsage() && TreeUtils.firstAncestorOfKind(u.tree(), Tree.Kind.IS) == null);
        }
        return false;
    }
}

