/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.AnyParameter;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S2325")
public class MethodShouldBeStaticCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Make this method static.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef funcDef = (FunctionDef)ctx.syntaxNode();
            if (!(!funcDef.isMethodDefinition() || CheckUtils.classHasInheritance(CheckUtils.getParentClassDef(funcDef)) || MethodShouldBeStaticCheck.isBuiltInMethod(funcDef) || MethodShouldBeStaticCheck.isStatic(funcDef) || !MethodShouldBeStaticCheck.hasValuableCode(funcDef) || MethodShouldBeStaticCheck.mayRaiseNotImplementedError(funcDef) || MethodShouldBeStaticCheck.isUsingSelfArg(funcDef))) {
                ctx.addIssue(funcDef.name(), MESSAGE);
            }
        });
    }

    private static boolean mayRaiseNotImplementedError(FunctionDef funcDef) {
        RaiseStatementVisitor visitor = new RaiseStatementVisitor();
        funcDef.accept(visitor);
        return visitor.hasNotImplementedError;
    }

    private static boolean hasValuableCode(FunctionDef funcDef) {
        List<Statement> statements = funcDef.body().statements();
        return !statements.stream().allMatch(st -> MethodShouldBeStaticCheck.isStringLiteral(st) || st.is(Tree.Kind.PASS_STMT));
    }

    private static boolean isStringLiteral(Statement st) {
        return st.is(Tree.Kind.EXPRESSION_STMT) && ((ExpressionStatement)st).expressions().stream().allMatch(e -> e.is(Tree.Kind.STRING_LITERAL));
    }

    private static boolean isUsingSelfArg(FunctionDef funcDef) {
        ParameterList parameters = funcDef.parameters();
        if (parameters == null) {
            return true;
        }
        List<AnyParameter> params = parameters.all();
        if (params.isEmpty()) {
            return false;
        }
        if (params.get(0).is(Tree.Kind.TUPLE_PARAMETER)) {
            return false;
        }
        Parameter first = (Parameter)params.get(0);
        Name paramName = first.name();
        if (paramName == null) {
            return true;
        }
        SelfVisitor visitor = new SelfVisitor(paramName.name());
        funcDef.body().accept(visitor);
        return visitor.isUsingSelfArg;
    }

    private static boolean isStatic(FunctionDef funcDef) {
        return funcDef.decorators().stream().map(d -> TreeUtils.decoratorNameFromExpression(d.expression())).anyMatch(n -> "staticmethod".equals(n) || "classmethod".equals(n));
    }

    private static boolean isBuiltInMethod(FunctionDef funcDef) {
        String doubleUnderscore;
        String name = funcDef.name().name();
        return name.startsWith(doubleUnderscore = "__") && name.endsWith(doubleUnderscore);
    }

    private static class SelfVisitor
    extends BaseTreeVisitor {
        private final String selfName;
        boolean isUsingSelfArg = false;

        SelfVisitor(String selfName) {
            this.selfName = selfName;
        }

        @Override
        public void visitName(Name pyNameTree) {
            this.isUsingSelfArg |= this.selfName.equals(pyNameTree.name());
        }
    }

    private static class RaiseStatementVisitor
    extends BaseTreeVisitor {
        private int withinRaise = 0;
        boolean hasNotImplementedError = false;

        private RaiseStatementVisitor() {
        }

        @Override
        public void visitRaiseStatement(RaiseStatement pyRaiseStatementTree) {
            ++this.withinRaise;
            this.scan(pyRaiseStatementTree.expressions());
            --this.withinRaise;
        }

        @Override
        public void visitName(Name pyNameTree) {
            if (this.withinRaise > 0) {
                this.hasNotImplementedError |= pyNameTree.name().equals("NotImplementedError");
            }
        }
    }
}

