/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;

@Rule(key="PreIncrementDecrement")
public class PreIncrementDecrementCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "PreIncrementDecrement";
    private static final String MESSAGE = "This statement doesn't produce the expected result, replace use of non-existent pre-%srement operator";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.UNARY_PLUS, PreIncrementDecrementCheck::checkIncrementDecrement);
        context.registerSyntaxNodeConsumer(Tree.Kind.UNARY_MINUS, PreIncrementDecrementCheck::checkIncrementDecrement);
    }

    private static void checkIncrementDecrement(SubscriptionContext ctx) {
        UnaryExpression unaryExpressionTree = (UnaryExpression)ctx.syntaxNode();
        Tree.Kind kind = unaryExpressionTree.getKind();
        if (unaryExpressionTree.expression().is(kind)) {
            ctx.addIssue(unaryExpressionTree, String.format(MESSAGE, kind == Tree.Kind.UNARY_PLUS ? "inc" : "dec"));
        }
    }
}

