/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.python.checks.Expressions;

@Rule(key="S5247")
public class DisabledHtmlAutoEscapeCheck
extends PythonSubscriptionCheck {
    private static final String AUTO_ESCAPE = "autoescape";
    private static final String MESSAGE = "Make sure disabling auto-escaping feature is safe here.";
    private static final Set<String> JINJA_ENVIRONMNENT_FQN_SET;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> this.checkCallExpression((SubscriptionContext)ctx, (CallExpression)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.KEY_VALUE_PAIR, ctx -> this.checkKeyValuePair((SubscriptionContext)ctx, (KeyValuePair)ctx.syntaxNode()));
    }

    private void checkKeyValuePair(SubscriptionContext ctx, KeyValuePair keyValue) {
        if (!"settings.py".equals(ctx.pythonFile().fileName())) {
            return;
        }
        if (DisabledHtmlAutoEscapeCheck.isStringLiteral(keyValue.key(), AUTO_ESCAPE) && Expressions.isFalsy(keyValue.value())) {
            ctx.addIssue(keyValue, this.message());
        }
    }

    private static boolean isStringLiteral(Expression tree, String testedValue) {
        return tree.is(Tree.Kind.STRING_LITERAL) && testedValue.equals(Expressions.unescape((StringLiteral)tree));
    }

    private void checkCallExpression(SubscriptionContext ctx, CallExpression call) {
        Symbol symbol = call.calleeSymbol();
        if (symbol != null && JINJA_ENVIRONMNENT_FQN_SET.contains(symbol.fullyQualifiedName())) {
            List<Argument> arguments = call.arguments();
            for (Argument argument : arguments) {
                Expression expression;
                if (!argument.is(Tree.Kind.UNPACKING_EXPR) || !(expression = ((UnpackingExpression)argument).expression()).is(Tree.Kind.NAME)) continue;
                this.checkJinjaOptions(ctx, call, (Name)expression);
                return;
            }
            Stream<RegularArgument> autoEscapeArgs = arguments.stream().filter(arg -> arg.is(Tree.Kind.REGULAR_ARGUMENT)).map(RegularArgument.class::cast).filter(DisabledHtmlAutoEscapeCheck::isAutoEscapeArgument);
            if (autoEscapeArgs.allMatch(arg -> Expressions.isFalsy(arg.expression()))) {
                ctx.addIssue(call, this.message());
            }
        }
    }

    private void checkJinjaOptions(SubscriptionContext ctx, CallExpression call, Name expression) {
        Expression options = Expressions.singleAssignedValue(expression);
        if (options != null && options.is(Tree.Kind.DICTIONARY_LITERAL)) {
            DictionaryLiteral dict = (DictionaryLiteral)options;
            Optional<Expression> autoEscapeOption = dict.elements().stream().filter(elem -> elem.is(Tree.Kind.KEY_VALUE_PAIR)).map(KeyValuePair.class::cast).filter(kv -> DisabledHtmlAutoEscapeCheck.isStringLiteral(kv.key(), AUTO_ESCAPE)).map(KeyValuePair::value).findFirst();
            if (!autoEscapeOption.isPresent() || Expressions.isFalsy(autoEscapeOption.get())) {
                ctx.addIssue(call, this.message());
            }
        }
    }

    private static boolean isAutoEscapeArgument(RegularArgument argument) {
        Name keyword = argument.keywordArgument();
        return keyword != null && AUTO_ESCAPE.equals(keyword.name());
    }

    String message() {
        return MESSAGE;
    }

    static {
        HashSet<String> environmentFqnSet = new HashSet<String>();
        environmentFqnSet.add("jinja2.Environment");
        environmentFqnSet.add("jinja2.environment.Environment");
        JINJA_ENVIRONMNENT_FQN_SET = environmentFqnSet;
    }
}

