/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.python.semantic.SymbolImpl;

public class AmbiguousSymbolImpl
extends SymbolImpl
implements AmbiguousSymbol {
    private final Set<Symbol> symbols;

    public AmbiguousSymbolImpl(String name, @Nullable String fullyQualifiedName, Set<Symbol> symbols) {
        super(name, fullyQualifiedName);
        this.setKind(Symbol.Kind.AMBIGUOUS);
        this.symbols = symbols;
    }

    public static AmbiguousSymbol create(Set<Symbol> symbols) {
        if (symbols.size() < 2) {
            throw new IllegalArgumentException("Ambiguous symbol should contain at least two symbols");
        }
        Symbol firstSymbol = symbols.iterator().next();
        String resultingSymbolName = firstSymbol.name();
        if (!symbols.stream().map(Symbol::name).allMatch(symbolName -> symbolName.equals(firstSymbol.name()))) {
            if (!symbols.stream().map(Symbol::fullyQualifiedName).allMatch(fqn -> Objects.equals(firstSymbol.fullyQualifiedName(), fqn))) {
                throw new IllegalArgumentException("Ambiguous symbol should contain symbols with the same name");
            }
            resultingSymbolName = "";
        }
        if (!symbols.stream().map(Symbol::fullyQualifiedName).allMatch(fqn -> Objects.equals(firstSymbol.fullyQualifiedName(), fqn))) {
            return new AmbiguousSymbolImpl(resultingSymbolName, null, symbols);
        }
        return new AmbiguousSymbolImpl(resultingSymbolName, firstSymbol.fullyQualifiedName(), symbols);
    }

    public static AmbiguousSymbol create(Symbol ... symbols) {
        return AmbiguousSymbolImpl.create(new HashSet<Symbol>(Arrays.asList(symbols)));
    }

    @Override
    public Set<Symbol> alternatives() {
        return this.symbols;
    }

    @Override
    AmbiguousSymbolImpl copyWithoutUsages() {
        Set copiedAlternativeSymbols = this.symbols.stream().map(SymbolImpl.class::cast).map(SymbolImpl::copyWithoutUsages).collect(Collectors.toSet());
        return (AmbiguousSymbolImpl)AmbiguousSymbolImpl.create(Collections.unmodifiableSet(copiedAlternativeSymbols));
    }

    @Override
    public void removeUsages() {
        super.removeUsages();
        this.symbols.forEach(symbol -> ((SymbolImpl)symbol).removeUsages());
    }
}

