/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.PyTree;
import org.sonar.python.types.InferredTypes;

public class ComprehensionExpressionImpl
extends PyTree
implements ComprehensionExpression {
    private final Tree.Kind kind;
    private final Token openingToken;
    private final Expression resultExpression;
    private final ComprehensionFor comprehensionFor;
    private final Token closingToken;
    private Set<Symbol> symbols = new HashSet<Symbol>();

    public ComprehensionExpressionImpl(Tree.Kind kind, @Nullable Token openingToken, Expression resultExpression, ComprehensionFor compFor, @Nullable Token closingToken) {
        this.kind = kind;
        this.resultExpression = resultExpression;
        this.comprehensionFor = compFor;
        this.openingToken = openingToken;
        this.closingToken = closingToken;
    }

    @Override
    public Expression resultExpression() {
        return this.resultExpression;
    }

    @Override
    public ComprehensionFor comprehensionFor() {
        return this.comprehensionFor;
    }

    @Override
    public Set<Symbol> localVariables() {
        return this.symbols;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitPyListOrSetCompExpression(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.openingToken, this.resultExpression, this.comprehensionFor, this.closingToken).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    public void addLocalVariableSymbol(Symbol symbol) {
        this.symbols.add(symbol);
    }

    @Override
    public InferredType type() {
        switch (this.kind) {
            case LIST_COMPREHENSION: {
                return InferredTypes.LIST;
            }
            case SET_COMPREHENSION: {
                return InferredTypes.SET;
            }
        }
        return InferredTypes.anyType();
    }
}

