/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.tree.GlobalStatement;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class GlobalStatementImpl
extends SimpleStatement
implements GlobalStatement {
    private final Token globalKeyword;
    private final List<Name> variables;
    private final Separators separators;

    public GlobalStatementImpl(Token globalKeyword, List<Name> variables, Separators separators) {
        this.globalKeyword = globalKeyword;
        this.variables = variables;
        this.separators = separators;
    }

    @Override
    public Token globalKeyword() {
        return this.globalKeyword;
    }

    @Override
    public List<Name> variables() {
        return this.variables;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.GLOBAL_STMT;
    }

    @Override
    @CheckForNull
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitGlobalStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Collections.singletonList(this.globalKeyword), this.variables, this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

