/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.PrintStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class PrintStatementImpl
extends SimpleStatement
implements PrintStatement {
    private final Token printKeyword;
    private final List<Expression> expressions;
    private final Separators separators;

    public PrintStatementImpl(Token printKeyword, List<Expression> expressions, Separators separators) {
        this.printKeyword = printKeyword;
        this.expressions = expressions;
        this.separators = separators;
    }

    @Override
    public Token printKeyword() {
        return this.printKeyword;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressions;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PRINT_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitPrintStatement(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Collections.singletonList(this.printKeyword), this.expressions, this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

