/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.WhileStatement;
import org.sonar.python.tree.PyTree;

public class WhileStatementImpl
extends PyTree
implements WhileStatement {
    private final Token whileKeyword;
    private final Expression condition;
    private final Token colon;
    private final Token firstNewline;
    private final Token firstIndent;
    private final StatementList body;
    private final Token firstDedent;
    private final ElseClause elseClause;

    public WhileStatementImpl(Token whileKeyword, Expression condition, Token colon, @Nullable Token firstNewline, @Nullable Token firstIndent, StatementList body, @Nullable Token firstDedent, @Nullable ElseClause elseClause) {
        this.whileKeyword = whileKeyword;
        this.condition = condition;
        this.colon = colon;
        this.firstNewline = firstNewline;
        this.firstIndent = firstIndent;
        this.body = body;
        this.firstDedent = firstDedent;
        this.elseClause = elseClause;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.WHILE_STMT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitWhileStatement(this);
    }

    @Override
    public Token whileKeyword() {
        return this.whileKeyword;
    }

    @Override
    public Expression condition() {
        return this.condition;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public StatementList body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public ElseClause elseClause() {
        return this.elseClause;
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.whileKeyword, this.condition, this.colon, this.firstNewline, this.firstIndent, this.body, this.firstDedent, this.elseClause).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

