/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.types;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.symbols.AmbiguousSymbol;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.AnyType;
import org.sonar.python.types.DeclaredType;
import org.sonar.python.types.RuntimeType;
import org.sonar.python.types.TypeShed;
import org.sonar.python.types.UnionType;

public class InferredTypes {
    private static final Map<String, String> ALIASED_ANNOTATIONS = new HashMap<String, String>();
    public static final InferredType INT;
    public static final InferredType DECL_INT;
    public static final InferredType FLOAT;
    public static final InferredType DECL_FLOAT;
    public static final InferredType COMPLEX;
    public static final InferredType DECL_COMPLEX;
    public static final InferredType STR;
    public static final InferredType DECL_STR;
    public static final InferredType SET;
    public static final InferredType DECL_SET;
    public static final InferredType DICT;
    public static final InferredType DECL_DICT;
    public static final InferredType LIST;
    public static final InferredType DECL_LIST;
    public static final InferredType TUPLE;
    public static final InferredType DECL_TUPLE;
    public static final InferredType NONE;
    public static final InferredType DECL_NONE;
    public static final InferredType BOOL;
    public static final InferredType DECL_BOOL;
    private static Map<String, Symbol> builtinSymbols;
    private static final String UNICODE = "unicode";
    private static final Map<String, Set<String>> HARDCODED_COMPATIBLE_TYPES;

    private InferredTypes() {
    }

    public static boolean isInitialized() {
        return builtinSymbols != null;
    }

    public static InferredType anyType() {
        return AnyType.ANY;
    }

    static InferredType runtimeBuiltinType(String fullyQualifiedName) {
        return new RuntimeType(TypeShed.typeShedClass(fullyQualifiedName));
    }

    private static InferredType declaredBuiltinType(String fullyQualifiedName) {
        return new DeclaredType(TypeShed.typeShedClass(fullyQualifiedName));
    }

    public static InferredType runtimeType(@Nullable Symbol typeClass) {
        if (typeClass instanceof ClassSymbol) {
            return new RuntimeType((ClassSymbol)typeClass);
        }
        if (typeClass instanceof AmbiguousSymbol) {
            return InferredTypes.union(((AmbiguousSymbol)typeClass).alternatives().stream().map(InferredTypes::runtimeType));
        }
        return InferredTypes.anyType();
    }

    static void setBuiltinSymbols(Map<String, Symbol> builtinSymbols) {
        InferredTypes.builtinSymbols = Collections.unmodifiableMap(builtinSymbols);
    }

    public static InferredType or(InferredType t1, InferredType t2) {
        return UnionType.or(t1, t2);
    }

    public static InferredType union(Stream<InferredType> types) {
        return types.reduce(InferredTypes::or).orElse(InferredTypes.anyType());
    }

    public static InferredType fromTypeAnnotation(TypeAnnotation typeAnnotation) {
        Map<String, Symbol> builtins = builtinSymbols != null ? builtinSymbols : Collections.emptyMap();
        DeclaredType declaredType = InferredTypes.declaredTypeFromTypeAnnotation(typeAnnotation.expression(), builtins);
        if (declaredType == null) {
            return InferredTypes.anyType();
        }
        return declaredType;
    }

    public static InferredType fromTypeshedTypeAnnotation(TypeAnnotation typeAnnotation) {
        Map<String, Symbol> builtins = builtinSymbols != null ? builtinSymbols : Collections.emptyMap();
        return InferredTypes.runtimeTypefromTypeAnnotation(typeAnnotation.expression(), builtins);
    }

    @CheckForNull
    private static DeclaredType declaredTypeFromTypeAnnotation(Expression expression, Map<String, Symbol> builtinSymbols) {
        Symbol symbol;
        if (expression.is(Tree.Kind.NAME) && !((Name)expression).name().equals("Any") && (symbol = ((Name)expression).symbol()) != null) {
            String builtinFqn = ALIASED_ANNOTATIONS.get(symbol.fullyQualifiedName());
            return builtinFqn != null ? new DeclaredType(builtinSymbols.get(builtinFqn)) : new DeclaredType(symbol);
        }
        if (expression.is(Tree.Kind.SUBSCRIPTION)) {
            return InferredTypes.declaredTypeFromTypeAnnotationSubscription((SubscriptionExpression)expression, builtinSymbols);
        }
        if (expression.is(Tree.Kind.NONE)) {
            return new DeclaredType(builtinSymbols.get("NoneType"));
        }
        return null;
    }

    @CheckForNull
    private static DeclaredType declaredTypeFromTypeAnnotationSubscription(SubscriptionExpression subscription, Map<String, Symbol> builtinSymbols) {
        if (InferredTypes.isAnnotatedSubscription(subscription)) {
            return InferredTypes.declaredTypeFromTypeAnnotation(subscription.subscripts().expressions().get(0), builtinSymbols);
        }
        return TreeUtils.getSymbolFromTree(subscription.object()).map(symbol -> {
            String builtinFqn;
            List<DeclaredType> args = subscription.subscripts().expressions().stream().map(exp -> InferredTypes.declaredTypeFromTypeAnnotation(exp, builtinSymbols)).collect(Collectors.toList());
            if (args.stream().anyMatch(Objects::isNull)) {
                args = Collections.emptyList();
            }
            return (builtinFqn = ALIASED_ANNOTATIONS.get(symbol.fullyQualifiedName())) != null ? new DeclaredType((Symbol)builtinSymbols.get(builtinFqn), args) : new DeclaredType((Symbol)symbol, args);
        }).orElse(null);
    }

    private static InferredType runtimeTypefromTypeAnnotation(Expression expression, Map<String, Symbol> builtinSymbols) {
        if (expression.is(Tree.Kind.NAME) && !((Name)expression).name().equals("Any")) {
            Symbol symbol2 = ((Name)expression).symbol();
            if (symbol2 != null) {
                if ("typing.Text".equals(symbol2.fullyQualifiedName())) {
                    return InferredTypes.runtimeType(builtinSymbols.get("str"));
                }
                return InferredTypes.genericType(symbol2, Collections.emptyList(), builtinSymbols);
            }
            return InferredTypes.anyType();
        }
        if (expression.is(Tree.Kind.SUBSCRIPTION)) {
            SubscriptionExpression subscription = (SubscriptionExpression)expression;
            if (InferredTypes.isAnnotatedSubscription(subscription)) {
                return InferredTypes.runtimeTypefromTypeAnnotation(subscription.subscripts().expressions().get(0), builtinSymbols);
            }
            return TreeUtils.getSymbolFromTree(subscription.object()).map(symbol -> InferredTypes.genericType(symbol, subscription.subscripts().expressions(), builtinSymbols)).orElse(InferredTypes.anyType());
        }
        if (expression.is(Tree.Kind.NONE)) {
            return InferredTypes.runtimeType(builtinSymbols.get("NoneType"));
        }
        return InferredTypes.anyType();
    }

    private static boolean isAnnotatedSubscription(SubscriptionExpression subscription) {
        Optional<Symbol> objectSymbol = TreeUtils.getSymbolFromTree(subscription.object());
        return objectSymbol.isPresent() && "typing.Annotated".equals(objectSymbol.get().fullyQualifiedName());
    }

    private static InferredType genericType(Symbol symbol, List<Expression> subscripts, Map<String, Symbol> builtinSymbols) {
        String builtinFqn = ALIASED_ANNOTATIONS.get(symbol.fullyQualifiedName());
        if (builtinFqn == null) {
            if ("typing.Optional".equals(symbol.fullyQualifiedName()) && subscripts.size() == 1) {
                InferredType noneType = InferredTypes.runtimeType(builtinSymbols.get("NoneType"));
                return InferredTypes.or(InferredTypes.runtimeTypefromTypeAnnotation(subscripts.get(0), builtinSymbols), noneType);
            }
            if ("typing.Union".equals(symbol.fullyQualifiedName())) {
                return InferredTypes.union(subscripts.stream().map(s -> InferredTypes.runtimeTypefromTypeAnnotation(s, builtinSymbols)));
            }
            return InferredTypes.runtimeType(symbol);
        }
        return InferredTypes.runtimeType(builtinSymbols.get(builtinFqn));
    }

    public static Collection<ClassSymbol> typeSymbols(InferredType inferredType) {
        if (inferredType instanceof RuntimeType) {
            return Collections.singleton(((RuntimeType)inferredType).getTypeClass());
        }
        if (inferredType instanceof DeclaredType) {
            Symbol typeClass = ((DeclaredType)inferredType).getTypeClass();
            return typeClass.is(Symbol.Kind.CLASS) ? Collections.singleton((ClassSymbol)typeClass) : Collections.emptySet();
        }
        if (inferredType instanceof UnionType) {
            HashSet<ClassSymbol> typeClasses = new HashSet<ClassSymbol>();
            ((UnionType)inferredType).types().forEach(type -> typeClasses.addAll(InferredTypes.typeSymbols(type)));
            return typeClasses;
        }
        return Collections.emptySet();
    }

    @CheckForNull
    public static String typeName(InferredType inferredType) {
        if (inferredType instanceof DeclaredType) {
            return ((DeclaredType)inferredType).typeName();
        }
        Collection<ClassSymbol> typeClasses = InferredTypes.typeSymbols(inferredType);
        if (typeClasses.size() == 1) {
            return typeClasses.iterator().next().name();
        }
        return null;
    }

    @CheckForNull
    public static LocationInFile typeClassLocation(InferredType inferredType) {
        Collection<ClassSymbol> typeClasses = InferredTypes.typeSymbols(inferredType);
        if (typeClasses.size() == 1) {
            return typeClasses.iterator().next().definitionLocation();
        }
        return null;
    }

    public static boolean isDeclaredTypeWithTypeClass(InferredType type, String typeName) {
        if (type instanceof DeclaredType) {
            Symbol typeClass = ((DeclaredType)type).getTypeClass();
            return typeName.equals(typeClass.fullyQualifiedName());
        }
        return false;
    }

    static boolean isTypeClassCompatibleWith(Symbol typeClass, InferredType other) {
        if (other instanceof RuntimeType) {
            return InferredTypes.areSymbolsCompatible(typeClass, ((RuntimeType)other).getTypeClass());
        }
        if (other instanceof DeclaredType) {
            if (((DeclaredType)other).alternativeTypeSymbols().isEmpty()) {
                return true;
            }
            return ((DeclaredType)other).alternativeTypeSymbols().stream().anyMatch(a -> InferredTypes.areSymbolsCompatible(typeClass, a));
        }
        if (other instanceof UnionType) {
            return ((UnionType)other).types().stream().anyMatch(t -> InferredTypes.isTypeClassCompatibleWith(typeClass, t));
        }
        return true;
    }

    static boolean areSymbolsCompatible(Symbol actual, Symbol expected) {
        if (!expected.is(Symbol.Kind.CLASS) || !actual.is(Symbol.Kind.CLASS)) {
            return true;
        }
        ClassSymbol actualTypeClass = (ClassSymbol)actual;
        ClassSymbol expectedTypeClass = (ClassSymbol)expected;
        String otherFullyQualifiedName = expectedTypeClass.fullyQualifiedName();
        boolean areHardcodedCompatible = InferredTypes.areHardcodedCompatible(actualTypeClass, expectedTypeClass);
        boolean isDuckTypeCompatible = !"NoneType".equals(otherFullyQualifiedName) && expectedTypeClass.declaredMembers().stream().allMatch(m -> actualTypeClass.resolveMember(m.name()).isPresent());
        boolean canBeOrExtend = otherFullyQualifiedName == null || actualTypeClass.canBeOrExtend(otherFullyQualifiedName);
        return areHardcodedCompatible || isDuckTypeCompatible || canBeOrExtend;
    }

    private static boolean areHardcodedCompatible(ClassSymbol actual, ClassSymbol expected) {
        Set compatibleTypes = HARDCODED_COMPATIBLE_TYPES.getOrDefault(actual.fullyQualifiedName(), Collections.emptySet());
        return compatibleTypes.stream().anyMatch(expected::canBeOrExtend);
    }

    public static boolean containsDeclaredType(InferredType type) {
        if (type instanceof DeclaredType) {
            return true;
        }
        if (type instanceof UnionType) {
            return ((UnionType)type).types().stream().anyMatch(InferredTypes::containsDeclaredType);
        }
        return false;
    }

    static {
        ALIASED_ANNOTATIONS.put("typing.List", "list");
        ALIASED_ANNOTATIONS.put("typing.Tuple", "tuple");
        ALIASED_ANNOTATIONS.put("typing.Dict", "dict");
        ALIASED_ANNOTATIONS.put("typing.Set", "set");
        ALIASED_ANNOTATIONS.put("typing.FrozenSet", "frozenset");
        ALIASED_ANNOTATIONS.put("typing.Type", "type");
        INT = InferredTypes.runtimeBuiltinType("int");
        DECL_INT = InferredTypes.declaredBuiltinType("int");
        FLOAT = InferredTypes.runtimeBuiltinType("float");
        DECL_FLOAT = InferredTypes.declaredBuiltinType("float");
        COMPLEX = InferredTypes.runtimeBuiltinType("complex");
        DECL_COMPLEX = InferredTypes.declaredBuiltinType("complex");
        STR = InferredTypes.runtimeBuiltinType("str");
        DECL_STR = InferredTypes.declaredBuiltinType("str");
        SET = InferredTypes.runtimeBuiltinType("set");
        DECL_SET = InferredTypes.declaredBuiltinType("set");
        DICT = InferredTypes.runtimeBuiltinType("dict");
        DECL_DICT = InferredTypes.declaredBuiltinType("dict");
        LIST = InferredTypes.runtimeBuiltinType("list");
        DECL_LIST = InferredTypes.declaredBuiltinType("list");
        TUPLE = InferredTypes.runtimeBuiltinType("tuple");
        DECL_TUPLE = InferredTypes.declaredBuiltinType("tuple");
        NONE = InferredTypes.runtimeBuiltinType("NoneType");
        DECL_NONE = InferredTypes.declaredBuiltinType("NoneType");
        BOOL = InferredTypes.runtimeBuiltinType("bool");
        DECL_BOOL = InferredTypes.declaredBuiltinType("bool");
        HARDCODED_COMPATIBLE_TYPES = new HashMap<String, Set<String>>();
        HARDCODED_COMPATIBLE_TYPES.put("int", new HashSet<String>(Arrays.asList("float", "complex")));
        HARDCODED_COMPATIBLE_TYPES.put("float", new HashSet<String>(Collections.singletonList("complex")));
        HARDCODED_COMPATIBLE_TYPES.put("bytearray", new HashSet<String>(Arrays.asList("bytes", "str", UNICODE)));
        HARDCODED_COMPATIBLE_TYPES.put("memoryview", new HashSet<String>(Arrays.asList("bytes", "str", UNICODE)));
        HARDCODED_COMPATIBLE_TYPES.put("str", new HashSet<String>(Collections.singletonList(UNICODE)));
    }
}

