/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex;

import com.sonar.sslr.api.GenericTokenType;
import java.util.List;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.FlexPunctuator;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.parser.LexerlessGrammar;

public enum FlexGrammar implements GrammarRuleKey
{
    WHITESPACE,
    SPACING,
    SPACING_NO_LB,
    NEXT_NOT_LB,
    EOS,
    EOS_NO_LB,
    STRING,
    NUMBER,
    DECIMAL,
    HEXADECIMAL,
    OCTAL,
    PRIMARY_EXPR,
    RESERVED_NAMESPACE,
    PARENTHESIZED_EXPR,
    PARENTHESIZED_LIST_EXPR,
    FUNCTION_EXPR,
    OBJECT_INITIALISER,
    FIELD_NAME,
    LITERAL_FIELD,
    ARRAY_INITIALISER,
    ELEMENT_LIST,
    LITERAL_ELEMENT,
    CONDITIONAL_EXPR,
    CONDITIONAL_EXPR_NO_IN,
    POSTFIX_EXPR,
    COMPOUND_ASSIGNMENT,
    LOGICAL_ASSIGNMENT,
    SUPER_EXPR,
    PROPERTY_IDENTIFIER,
    QUALIFIER,
    SIMPLE_QUALIFIED_IDENTIFIER,
    EXPR_QUALIFIED_IDENTIFIER,
    NON_ATTRIBUTE_QUALIFIED_IDENTIFIER,
    QUALIFIED_IDENTIFIER,
    BRACKETS,
    IDENTIFIER,
    IDENTIFIER_PART,
    FULL_NEW_EXPR,
    FULL_NEW_SUB_EXPR,
    SHORT_NEW_EXPR,
    SHORT_NEW_SUB_EXPR,
    PROPERTY_OPERATOR,
    QUERY_OPERATOR,
    ARGUMENTS,
    UNARY_EXPR,
    MULTIPLICATIVE_EXPR,
    ADDITIVE_EXPR,
    ADDITIVE_OPERATOR,
    SHIFT_EXPR,
    RELATIONAL_EXPR,
    RELATIONAL_EXPR_NO_IN,
    RELATIONAL_OPERATOR,
    RELATIONAL_OPERATOR_NO_IN,
    EQUALITY_EXPR,
    EQUALITY_EXPR_NO_IN,
    EQUALITY_OPERATOR,
    BITEWISE_AND_EXPR,
    BITEWISE_AND_EXPR_NO_IN,
    BITEWISE_XOR_EXPR,
    BITEWISE_XOR_EXPR_NO_IN,
    BITEWISE_OR_EXPR,
    BITEWISE_OR_EXPR_NO_IN,
    LOGICAL_AND_EXPR,
    LOGICAL_AND_EXPR_NO_IN,
    LOGICAL_AND_OPERATOR,
    LOGICAL_OR_EXPR,
    LOGICAL_OR_EXPR_NO_IN,
    LOGICAL_OR_OPERATOR,
    ASSIGNMENT_EXPR,
    ASSIGNMENT_EXPR_NO_IN,
    ASSIGNMENT_OPERATOR,
    LIST_EXPRESSION,
    LIST_EXPRESSION_NO_IN,
    NON_ASSIGNMENT_EXPR,
    NON_ASSIGNMENT_EXPR_NO_IN,
    TYPE_EXPR,
    TYPE_EXPR_NO_IN,
    TYPE_APPLICATION,
    VECTOR_LITERAL_EXPRESSION,
    XML_INITIALISER,
    XML_MARKUP,
    XML_ELEMENT,
    XML_TAG_CONTENT,
    XML_WHITESPACE,
    XML_TAG_NAME,
    XML_ATTRIBUTE,
    XML_ATTRIBUTES,
    XML_ATTRIBUTE_VALUE,
    XML_NAME,
    XML_ELEMENT_CONTENT,
    XML_TEXT,
    XML_COMMENT,
    XML_CDATA,
    XML_PI,
    KEYWORDS,
    REGULAR_EXPRESSION,
    VARIABLE_DEF,
    VARIABLE_DEF_NO_IN,
    VARIABLE_DEF_KIND,
    VARIABLE_BINDING_LIST,
    VARIABLE_BINDING_LIST_NO_IN,
    VARIABLE_BINDING,
    VARIABLE_BINDING_NO_IN,
    VARIABLE_INITIALISATION,
    VARIABLE_INITIALISATION_NO_IN,
    TYPED_IDENTIFIER,
    TYPED_IDENTIFIER_NO_IN,
    VARIABLE_INITIALISER,
    VARIABLE_INITIALISER_NO_IN,
    FUNCTION_DEF,
    FUNCTION_NAME,
    FUNCTION_COMMON,
    FUNCTION_SIGNATURE,
    RESULT_TYPE,
    PARAMETERS,
    PARAMETER,
    REST_PARAMETERS,
    CLASS_DEF,
    CLASS_NAME,
    INHERITENCE,
    CLASS_IDENTIFIERS,
    TYPE_EXPRESSION_LIST,
    INTERFACE_DEF,
    EXTENDS_LIST,
    PACKAGE_DEF,
    PACKAGE_NAME,
    NAMESPACE_DEF,
    NAMESPACE_BINDING,
    NAMESPACE_INITIALISATION,
    PROGRAM,
    STATEMENT,
    SUPER_STATEMENT,
    SWITCH_STATEMENT,
    IF_STATEMENT,
    DO_STATEMENT,
    WHILE_STATEMENT,
    FOR_STATEMENT,
    WITH_STATEMENT,
    CONTINUE_STATEMENT,
    BREAK_STATEMENT,
    RETURN_STATEMENT,
    THROW_STATEMENT,
    TRY_STATEMENT,
    EXPRESSION_STATEMENT,
    EXPRESSION,
    LABELED_STATEMENT,
    METADATA_STATEMENT,
    DEFAULT_XML_NAMESPACE_DIRECTIVE,
    SUB_STATEMENT,
    EMPTY_STATEMENT,
    VARIABLE_DECLARATION_STATEMENT,
    BLOCK,
    CASE_ELEMENT,
    CASE_LABEL,
    FOR_INITIALISER,
    FOR_IN_BINDING,
    CATCH_CLAUSE,
    CATCH_CLAUSES,
    DECIMAL_DIGITS,
    EXPONENT_PART,
    DECIMAL_INTEGER,
    DIRECTIVES,
    DIRECTIVE,
    CONFIG_CONDITION,
    ANNOTABLE_DIRECTIVE,
    USE_DIRECTIVE,
    IMPORT_DIRECTIVE,
    INCLUDE_DIRECTIVE,
    ATTRIBUTES,
    ATTRIBUTE,
    ATTRIBUTE_COMBINATION,
    ATTRIBUTE_EXPR;

    private static final String UNICODE_LETTER = "\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}";
    private static final String UNICODE_DIGIT = "\\p{Nd}";
    private static final String UNICODE_COMBINING_MARK = "\\p{Mn}\\p{Mc}";
    private static final String UNICODE_CONNECTOR_PUNCTUATION = "\\p{Pc}";
    private static final String UNICODE_ESCAPE_SEQUENCE_REGEXP = "u[0-9a-fA-F]{4,4}";
    private static final String IDENTIFIER_START_REGEXP = "(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F]{4,4})";
    private static final String IDENTIFIER_PART_REGEXP = "(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F]{4,4})|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])";
    private static final String EXPONENT_PART_REGEXP = "([eE][-+]?[0-9]++)?";
    private static final String DECIMAL_INTEGER_REGEXP = "(0|([1-9][0-9]*+))";
    private static final String DECIMAL_DIGITS_REGEXP = "([0-9]*+)";
    private static final String DECIMAL_REGEXP = "(0|([1-9][0-9]*+))\\.([0-9]*+)?([eE][-+]?[0-9]++)?|\\.([0-9]*+)([eE][-+]?[0-9]++)?|(0|([1-9][0-9]*+))([eE][-+]?[0-9]++)?";
    private static final String SINGLE_LINE_COMMENT_REGEXP = "//[^\\n\\r]*+";
    private static final String MULTI_LINE_COMMENT_REGEXP = "/\\*[\\s\\S]*?\\*/";
    private static final String MULTI_LINE_COMMENT_NO_LB_REGEXP = "/\\*[^\\n\\r]*?\\*/";
    private static final String LINE_TERMINATOR_REGEXP = "\\n\\r\\p{Zl}\\p{Zp}";
    private static final String WHITESPACE_REGEXP = "\\t\\v\\f\\u0020\\u00A0\\uFEFF\\p{Zs}";
    public static final String STRING_REGEXP = "(?:\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"|'([^'\\\\]*+(\\\\[\\s\\S])?+)*+')";
    private static final String NEWLINE_REGEXP = "(?:\\n|\\r\\n|\\r)";

    public static LexerlessGrammar createGrammar() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        b.rule(WHITESPACE).is(b.regexp("[\\n\\r\\p{Zl}\\p{Zp}\\t\\v\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+"));
        b.rule(SPACING).is(b.skippedTrivia(WHITESPACE), b.zeroOrMore(b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|/\\*[\\s\\S]*?\\*/)")), b.skippedTrivia(WHITESPACE))).skip();
        b.rule(SPACING_NO_LB).is(b.zeroOrMore(b.firstOf(b.skippedTrivia(b.regexp("[\\s&&[^\n\r]]++")), b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|/\\*[^\\n\\r]*?\\*/)"))))).skip();
        b.rule(NEXT_NOT_LB).is(b.nextNot(b.regexp("(?:[\n\r]|/\\*[\\s\\S]*?\\*/)"))).skip();
        b.rule(EOS).is(b.firstOf(b.sequence(SPACING, ";"), b.sequence(SPACING_NO_LB, b.regexp(NEWLINE_REGEXP)), b.sequence(SPACING_NO_LB, b.next("}")), b.sequence(SPACING, b.endOfInput())));
        b.rule(EOS_NO_LB).is(b.firstOf(b.sequence(SPACING_NO_LB, ";"), b.sequence(SPACING_NO_LB, b.regexp(NEWLINE_REGEXP)), b.sequence(SPACING_NO_LB, b.next("}")), b.sequence(SPACING_NO_LB, b.endOfInput())));
        FlexGrammar.punctuators(b);
        FlexGrammar.keywords(b);
        FlexGrammar.literals(b);
        FlexGrammar.expressions(b);
        FlexGrammar.statements(b);
        FlexGrammar.directives(b);
        FlexGrammar.definitions(b);
        FlexGrammar.xml(b);
        b.setRootRule(PROGRAM);
        return b.build();
    }

    private static void literals(LexerlessGrammarBuilder b) {
        b.rule(STRING).is(SPACING, b.regexp(STRING_REGEXP));
        b.rule(HEXADECIMAL).is(SPACING, b.regexp("0[xX][0-9a-fA-F]++"));
        b.rule(OCTAL).is(SPACING, b.regexp("0[0-7]++"));
        b.rule(DECIMAL).is(SPACING, b.regexp(DECIMAL_REGEXP));
        b.rule(NUMBER).is(b.firstOf(OCTAL, DECIMAL, HEXADECIMAL));
        b.rule(REGULAR_EXPRESSION).is(SPACING, b.regexp("/([^\\n\\r\\*\\\\/]|(\\\\[^\\n\\r]))([^\\n\\r\\\\/]|(\\\\[^\\n\\r]))*/(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F]{4,4})|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+"));
    }

    private static void expressions(LexerlessGrammarBuilder b) {
        b.rule(IDENTIFIER).is(b.firstOf(FlexKeyword.DYNAMIC, FlexKeyword.EACH, FlexKeyword.GET, FlexKeyword.INCLUDE, FlexKeyword.NAMESPACE, FlexKeyword.SET, FlexKeyword.STATIC, b.sequence(SPACING, b.nextNot(KEYWORDS), b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F]{4,4})(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F]{4,4})|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+"))));
        b.rule(IDENTIFIER_PART).is(b.regexp(IDENTIFIER_PART_REGEXP));
        b.rule(PROPERTY_IDENTIFIER).is(b.firstOf(IDENTIFIER, FlexPunctuator.STAR));
        b.rule(QUALIFIER).is(b.firstOf(PROPERTY_IDENTIFIER, RESERVED_NAMESPACE));
        b.rule(SIMPLE_QUALIFIED_IDENTIFIER).is(b.firstOf(b.sequence(QUALIFIER, FlexPunctuator.DOUBLE_COLON, PROPERTY_IDENTIFIER), b.sequence(QUALIFIER, FlexPunctuator.DOUBLE_COLON, BRACKETS), PROPERTY_IDENTIFIER));
        b.rule(EXPR_QUALIFIED_IDENTIFIER).is(b.firstOf(b.sequence(PARENTHESIZED_EXPR, FlexPunctuator.DOUBLE_COLON, PROPERTY_IDENTIFIER), b.sequence(PARENTHESIZED_EXPR, BRACKETS)));
        b.rule(NON_ATTRIBUTE_QUALIFIED_IDENTIFIER).is(b.firstOf(SIMPLE_QUALIFIED_IDENTIFIER, EXPR_QUALIFIED_IDENTIFIER));
        b.rule(QUALIFIED_IDENTIFIER).is(b.firstOf(b.sequence(FlexPunctuator.AT_SIGN, BRACKETS), b.sequence(FlexPunctuator.AT_SIGN, NON_ATTRIBUTE_QUALIFIED_IDENTIFIER), NON_ATTRIBUTE_QUALIFIED_IDENTIFIER));
        b.rule(PRIMARY_EXPR).is(b.firstOf(FlexKeyword.NULL, FlexKeyword.TRUE, FlexKeyword.FALSE, HEXADECIMAL, NUMBER, STRING, FlexKeyword.THIS, REGULAR_EXPRESSION, XML_INITIALISER, QUALIFIED_IDENTIFIER, RESERVED_NAMESPACE, PARENTHESIZED_EXPR, ARRAY_INITIALISER, OBJECT_INITIALISER, FUNCTION_EXPR));
        b.rule(RESERVED_NAMESPACE).is(b.firstOf(FlexKeyword.PUBLIC, FlexKeyword.PRIVATE, FlexKeyword.PROTECTED, FlexKeyword.INTERNAL));
        b.rule(PARENTHESIZED_EXPR).is(FlexPunctuator.LPARENTHESIS, ASSIGNMENT_EXPR, FlexPunctuator.RPARENTHESIS);
        b.rule(PARENTHESIZED_LIST_EXPR).is(FlexPunctuator.LPARENTHESIS, LIST_EXPRESSION, FlexPunctuator.RPARENTHESIS);
        b.rule(FUNCTION_EXPR).is(b.firstOf(b.sequence(FlexKeyword.FUNCTION, FUNCTION_COMMON), b.sequence(FlexKeyword.FUNCTION, IDENTIFIER, FUNCTION_COMMON)));
        b.rule(OBJECT_INITIALISER).is(FlexPunctuator.LCURLYBRACE, b.optional(LITERAL_FIELD, b.zeroOrMore(FlexPunctuator.COMMA, LITERAL_FIELD)), FlexPunctuator.RCURLYBRACE);
        b.rule(LITERAL_FIELD).is(FIELD_NAME, FlexPunctuator.COLON, ASSIGNMENT_EXPR);
        b.rule(FIELD_NAME).is(b.firstOf(NON_ATTRIBUTE_QUALIFIED_IDENTIFIER, STRING, NUMBER));
        b.rule(ARRAY_INITIALISER).is(FlexPunctuator.LBRAKET, b.optional(ELEMENT_LIST), FlexPunctuator.RBRAKET);
        b.rule(ELEMENT_LIST).is(b.optional(FlexPunctuator.COMMA), LITERAL_ELEMENT, b.zeroOrMore(FlexPunctuator.COMMA, LITERAL_ELEMENT), b.optional(FlexPunctuator.COMMA));
        b.rule(LITERAL_ELEMENT).is(ASSIGNMENT_EXPR);
        b.rule(ASSIGNMENT_EXPR).is(b.firstOf(b.sequence(POSTFIX_EXPR, ASSIGNMENT_OPERATOR, ASSIGNMENT_EXPR), CONDITIONAL_EXPR));
        b.rule(ASSIGNMENT_EXPR_NO_IN).is(b.firstOf(b.sequence(POSTFIX_EXPR, ASSIGNMENT_OPERATOR, ASSIGNMENT_EXPR_NO_IN), CONDITIONAL_EXPR));
        b.rule(ASSIGNMENT_OPERATOR).is(b.firstOf(FlexPunctuator.EQUAL1, COMPOUND_ASSIGNMENT, LOGICAL_ASSIGNMENT));
        b.rule(COMPOUND_ASSIGNMENT).is(b.firstOf(FlexPunctuator.STAR_EQU, FlexPunctuator.DIV_EQU, FlexPunctuator.MOD_EQU, FlexPunctuator.PLUS_EQU, FlexPunctuator.MINUS_EQU, FlexPunctuator.SL_EQU, FlexPunctuator.SR_EQU, FlexPunctuator.SR_EQU2, FlexPunctuator.AND_EQU, FlexPunctuator.XOR_EQU, FlexPunctuator.OR_EQU));
        b.rule(LOGICAL_ASSIGNMENT).is(b.firstOf(FlexPunctuator.ANDAND_EQU, FlexPunctuator.XORXOR_EQU, FlexPunctuator.OROR_EQU));
        b.rule(SUPER_EXPR).is(b.firstOf(b.sequence(FlexKeyword.SUPER, ARGUMENTS), FlexKeyword.SUPER));
        b.rule(POSTFIX_EXPR).is(b.firstOf(FULL_NEW_EXPR, b.sequence(SUPER_EXPR, b.optional(PROPERTY_OPERATOR)), PRIMARY_EXPR, SHORT_NEW_EXPR), b.zeroOrMore(b.firstOf(PROPERTY_OPERATOR, ARGUMENTS, QUERY_OPERATOR, b.sequence(SPACING_NO_LB, NEXT_NOT_LB, FlexPunctuator.DOUBLE_PLUS), b.sequence(SPACING_NO_LB, NEXT_NOT_LB, FlexPunctuator.DOUBLE_MINUS))));
        b.rule(FULL_NEW_EXPR).is(FlexKeyword.NEW, b.firstOf(FULL_NEW_SUB_EXPR, VECTOR_LITERAL_EXPRESSION), ARGUMENTS);
        b.rule(FULL_NEW_SUB_EXPR).is(b.firstOf(PRIMARY_EXPR, b.sequence(FULL_NEW_EXPR, PROPERTY_OPERATOR), FULL_NEW_EXPR, b.sequence(SUPER_EXPR, PROPERTY_OPERATOR)));
        b.rule(SHORT_NEW_EXPR).is(FlexKeyword.NEW, b.firstOf(SHORT_NEW_SUB_EXPR, VECTOR_LITERAL_EXPRESSION));
        b.rule(SHORT_NEW_SUB_EXPR).is(b.firstOf(FULL_NEW_SUB_EXPR, SHORT_NEW_EXPR));
        b.rule(PROPERTY_OPERATOR).is(b.firstOf(b.sequence(FlexPunctuator.DOT, QUALIFIED_IDENTIFIER), TYPE_APPLICATION, BRACKETS));
        b.rule(BRACKETS).is(FlexPunctuator.LBRAKET, LIST_EXPRESSION, FlexPunctuator.RBRAKET);
        b.rule(QUERY_OPERATOR).is(b.firstOf(b.sequence(FlexPunctuator.DOUBLE_DOT, QUALIFIED_IDENTIFIER), b.sequence(FlexPunctuator.DOT, FlexPunctuator.LPARENTHESIS, LIST_EXPRESSION, FlexPunctuator.RPARENTHESIS)));
        b.rule(ARGUMENTS).is(FlexPunctuator.LPARENTHESIS, b.optional(LIST_EXPRESSION), FlexPunctuator.RPARENTHESIS);
        b.rule(UNARY_EXPR).is(b.firstOf(b.sequence(b.firstOf(FlexKeyword.DELETE, FlexPunctuator.DOUBLE_PLUS, FlexPunctuator.DOUBLE_MINUS), POSTFIX_EXPR), b.sequence(b.firstOf(FlexKeyword.VOID, FlexKeyword.TYPEOF, FlexPunctuator.PLUS, FlexPunctuator.MINUS, FlexPunctuator.NOT, FlexPunctuator.TILD), UNARY_EXPR), POSTFIX_EXPR)).skipIfOneChild();
        b.rule(MULTIPLICATIVE_EXPR).is(UNARY_EXPR, b.zeroOrMore(b.firstOf(FlexPunctuator.STAR, FlexPunctuator.DIV, FlexPunctuator.MOD), UNARY_EXPR)).skipIfOneChild();
        b.rule(ADDITIVE_EXPR).is(MULTIPLICATIVE_EXPR, b.zeroOrMore(ADDITIVE_OPERATOR, MULTIPLICATIVE_EXPR)).skipIfOneChild();
        b.rule(ADDITIVE_OPERATOR).is(b.firstOf(FlexPunctuator.PLUS, FlexPunctuator.MINUS, FlexGrammar.word(b, "add")));
        b.rule(SHIFT_EXPR).is(ADDITIVE_EXPR, b.zeroOrMore(b.firstOf(FlexPunctuator.SL, FlexPunctuator.SR2, FlexPunctuator.SR), ADDITIVE_EXPR)).skipIfOneChild();
        b.rule(RELATIONAL_EXPR).is(SHIFT_EXPR, b.zeroOrMore(RELATIONAL_OPERATOR, SHIFT_EXPR)).skipIfOneChild();
        b.rule(RELATIONAL_EXPR_NO_IN).is(SHIFT_EXPR, b.zeroOrMore(RELATIONAL_OPERATOR_NO_IN, SHIFT_EXPR)).skipIfOneChild();
        b.rule(RELATIONAL_OPERATOR).is(b.firstOf(FlexPunctuator.LE, FlexPunctuator.GE, FlexPunctuator.LT, FlexPunctuator.GT, FlexKeyword.IN, FlexKeyword.INSTANCEOF, FlexKeyword.IS, FlexKeyword.AS, FlexGrammar.word(b, "le"), FlexGrammar.word(b, "ge"), FlexGrammar.word(b, "lt"), FlexGrammar.word(b, "gt")));
        b.rule(RELATIONAL_OPERATOR_NO_IN).is(b.firstOf(FlexPunctuator.LE, FlexPunctuator.GE, FlexPunctuator.LT, FlexPunctuator.GT, FlexKeyword.INSTANCEOF, FlexKeyword.IS, FlexKeyword.AS, FlexGrammar.word(b, "le"), FlexGrammar.word(b, "ge"), FlexGrammar.word(b, "lt"), FlexGrammar.word(b, "gt")));
        b.rule(EQUALITY_EXPR).is(RELATIONAL_EXPR, b.zeroOrMore(EQUALITY_OPERATOR, RELATIONAL_EXPR)).skipIfOneChild();
        b.rule(EQUALITY_EXPR_NO_IN).is(RELATIONAL_EXPR_NO_IN, b.zeroOrMore(EQUALITY_OPERATOR, RELATIONAL_EXPR_NO_IN)).skipIfOneChild();
        b.rule(EQUALITY_OPERATOR).is(b.firstOf(FlexPunctuator.NOTEQUAL2, FlexPunctuator.EQUAL3, FlexPunctuator.EQUAL2, FlexPunctuator.NOTEQUAL1, b.sequence(SPACING, "<>"), FlexGrammar.word(b, "eq"), FlexGrammar.word(b, "ne")));
        b.rule(BITEWISE_AND_EXPR).is(EQUALITY_EXPR, b.zeroOrMore(FlexPunctuator.AND, EQUALITY_EXPR)).skipIfOneChild();
        b.rule(BITEWISE_AND_EXPR_NO_IN).is(EQUALITY_EXPR_NO_IN, b.zeroOrMore(FlexPunctuator.AND, EQUALITY_EXPR_NO_IN)).skipIfOneChild();
        b.rule(BITEWISE_XOR_EXPR).is(BITEWISE_AND_EXPR, b.zeroOrMore(FlexPunctuator.XOR, BITEWISE_AND_EXPR)).skipIfOneChild();
        b.rule(BITEWISE_XOR_EXPR_NO_IN).is(BITEWISE_AND_EXPR_NO_IN, b.zeroOrMore(FlexPunctuator.XOR, BITEWISE_AND_EXPR_NO_IN)).skipIfOneChild();
        b.rule(BITEWISE_OR_EXPR).is(BITEWISE_XOR_EXPR, b.zeroOrMore(FlexPunctuator.OR, BITEWISE_XOR_EXPR)).skipIfOneChild();
        b.rule(BITEWISE_OR_EXPR_NO_IN).is(BITEWISE_XOR_EXPR_NO_IN, b.zeroOrMore(FlexPunctuator.OR, BITEWISE_XOR_EXPR_NO_IN)).skipIfOneChild();
        b.rule(LOGICAL_AND_EXPR).is(BITEWISE_OR_EXPR, b.zeroOrMore(LOGICAL_AND_OPERATOR, BITEWISE_XOR_EXPR)).skipIfOneChild();
        b.rule(LOGICAL_AND_EXPR_NO_IN).is(BITEWISE_OR_EXPR_NO_IN, b.zeroOrMore(LOGICAL_AND_OPERATOR, BITEWISE_XOR_EXPR_NO_IN)).skipIfOneChild();
        b.rule(LOGICAL_AND_OPERATOR).is(b.firstOf(FlexPunctuator.ANDAND, b.sequence(SPACING, "and", b.nextNot(IDENTIFIER_PART))));
        b.rule(LOGICAL_OR_EXPR).is(LOGICAL_AND_EXPR, b.zeroOrMore(LOGICAL_OR_OPERATOR, LOGICAL_AND_EXPR)).skipIfOneChild();
        b.rule(LOGICAL_OR_EXPR_NO_IN).is(LOGICAL_AND_EXPR_NO_IN, b.zeroOrMore(LOGICAL_OR_OPERATOR, LOGICAL_AND_EXPR_NO_IN)).skipIfOneChild();
        b.rule(LOGICAL_OR_OPERATOR).is(b.firstOf(FlexPunctuator.OROR, b.sequence(SPACING, "or", b.nextNot(IDENTIFIER_PART))));
        b.rule(CONDITIONAL_EXPR).is(LOGICAL_OR_EXPR, b.optional(FlexPunctuator.QUERY, ASSIGNMENT_EXPR, FlexPunctuator.COLON, ASSIGNMENT_EXPR)).skipIfOneChild();
        b.rule(CONDITIONAL_EXPR_NO_IN).is(LOGICAL_OR_EXPR_NO_IN, b.optional(FlexPunctuator.QUERY, ASSIGNMENT_EXPR_NO_IN, FlexPunctuator.COLON, ASSIGNMENT_EXPR_NO_IN)).skipIfOneChild();
        b.rule(NON_ASSIGNMENT_EXPR).is(LOGICAL_OR_EXPR, b.optional(FlexPunctuator.QUERY, NON_ASSIGNMENT_EXPR, FlexPunctuator.COLON, NON_ASSIGNMENT_EXPR)).skipIfOneChild();
        b.rule(NON_ASSIGNMENT_EXPR_NO_IN).is(LOGICAL_OR_EXPR_NO_IN, b.optional(FlexPunctuator.QUERY, NON_ASSIGNMENT_EXPR_NO_IN, FlexPunctuator.COLON, NON_ASSIGNMENT_EXPR_NO_IN)).skipIfOneChild();
        b.rule(LIST_EXPRESSION).is(ASSIGNMENT_EXPR, b.zeroOrMore(b.sequence(FlexPunctuator.COMMA, ASSIGNMENT_EXPR)));
        b.rule(LIST_EXPRESSION_NO_IN).is(ASSIGNMENT_EXPR_NO_IN, b.zeroOrMore(b.sequence(FlexPunctuator.COMMA, ASSIGNMENT_EXPR_NO_IN)));
        b.rule(TYPE_EXPR).is(b.firstOf(FlexPunctuator.STAR, b.sequence(QUALIFIED_IDENTIFIER, b.zeroOrMore(FlexPunctuator.DOT, QUALIFIED_IDENTIFIER), b.optional(TYPE_APPLICATION))));
        b.rule(TYPE_APPLICATION).is(FlexPunctuator.DOT, FlexPunctuator.LT, TYPE_EXPRESSION_LIST, FlexPunctuator.GT);
        b.rule(TYPE_EXPR_NO_IN).is(TYPE_EXPR);
        b.rule(VECTOR_LITERAL_EXPRESSION).is(FlexPunctuator.LT, TYPE_EXPR, FlexPunctuator.GT, BRACKETS);
    }

    private static void statements(LexerlessGrammarBuilder b) {
        b.rule(STATEMENT).is(b.firstOf(METADATA_STATEMENT, SUPER_STATEMENT, BLOCK, IF_STATEMENT, SWITCH_STATEMENT, DO_STATEMENT, WHILE_STATEMENT, FOR_STATEMENT, WITH_STATEMENT, CONTINUE_STATEMENT, BREAK_STATEMENT, RETURN_STATEMENT, THROW_STATEMENT, TRY_STATEMENT, EXPRESSION_STATEMENT, LABELED_STATEMENT));
        b.rule(SUB_STATEMENT).is(b.firstOf(EMPTY_STATEMENT, STATEMENT, VARIABLE_DECLARATION_STATEMENT));
        b.rule(EXPRESSION_STATEMENT).is(EXPRESSION, EOS);
        b.rule(METADATA_STATEMENT).is(FlexPunctuator.LBRAKET, ASSIGNMENT_EXPR, FlexPunctuator.RBRAKET);
        b.rule(VARIABLE_DECLARATION_STATEMENT).is(VARIABLE_DEF, EOS);
        b.rule(EMPTY_STATEMENT).is(FlexPunctuator.SEMICOLON);
        b.rule(SUPER_STATEMENT).is(FlexKeyword.SUPER, ARGUMENTS, EOS);
        b.rule(BLOCK).is(FlexPunctuator.LCURLYBRACE, DIRECTIVES, FlexPunctuator.RCURLYBRACE);
        b.rule(LABELED_STATEMENT).is(IDENTIFIER, FlexPunctuator.COLON, SUB_STATEMENT);
        b.rule(IF_STATEMENT).is(FlexKeyword.IF, PARENTHESIZED_LIST_EXPR, SUB_STATEMENT, b.optional(FlexKeyword.ELSE, SUB_STATEMENT));
        b.rule(SWITCH_STATEMENT).is(FlexKeyword.SWITCH, PARENTHESIZED_LIST_EXPR, FlexPunctuator.LCURLYBRACE, b.zeroOrMore(CASE_ELEMENT), FlexPunctuator.RCURLYBRACE);
        b.rule(CASE_ELEMENT).is(b.oneOrMore(CASE_LABEL), b.zeroOrMore(DIRECTIVE));
        b.rule(CASE_LABEL).is(b.firstOf(FlexKeyword.DEFAULT, b.sequence(FlexKeyword.CASE, LIST_EXPRESSION)), FlexPunctuator.COLON);
        b.rule(DO_STATEMENT).is(FlexKeyword.DO, SUB_STATEMENT, FlexKeyword.WHILE, PARENTHESIZED_LIST_EXPR, EOS);
        b.rule(WHILE_STATEMENT).is(FlexKeyword.WHILE, PARENTHESIZED_LIST_EXPR, SUB_STATEMENT);
        b.rule(FOR_STATEMENT).is(b.firstOf(b.sequence(FlexKeyword.FOR, FlexPunctuator.LPARENTHESIS, b.optional(FOR_INITIALISER), FlexPunctuator.SEMICOLON, b.optional(LIST_EXPRESSION), FlexPunctuator.SEMICOLON, b.optional(LIST_EXPRESSION), FlexPunctuator.RPARENTHESIS, SUB_STATEMENT), b.sequence(FlexKeyword.FOR, FlexPunctuator.LPARENTHESIS, FOR_IN_BINDING, FlexKeyword.IN, LIST_EXPRESSION, FlexPunctuator.RPARENTHESIS, SUB_STATEMENT), b.sequence(FlexKeyword.FOR, b.sequence(SPACING_NO_LB, NEXT_NOT_LB, FlexKeyword.EACH, FlexPunctuator.LPARENTHESIS, FOR_IN_BINDING, FlexKeyword.IN, LIST_EXPRESSION, FlexPunctuator.RPARENTHESIS, SUB_STATEMENT))));
        b.rule(FOR_INITIALISER).is(b.firstOf(LIST_EXPRESSION_NO_IN, VARIABLE_DEF_NO_IN));
        b.rule(FOR_IN_BINDING).is(b.firstOf(b.sequence(VARIABLE_DEF_KIND, VARIABLE_BINDING_NO_IN), POSTFIX_EXPR));
        b.rule(CONTINUE_STATEMENT).is(FlexKeyword.CONTINUE, b.firstOf(b.sequence(SPACING_NO_LB, NEXT_NOT_LB, IDENTIFIER, EOS), EOS_NO_LB));
        b.rule(BREAK_STATEMENT).is(FlexKeyword.BREAK, b.firstOf(b.sequence(SPACING_NO_LB, NEXT_NOT_LB, IDENTIFIER, EOS), EOS_NO_LB));
        b.rule(WITH_STATEMENT).is(FlexKeyword.WITH, PARENTHESIZED_LIST_EXPR, SUB_STATEMENT);
        b.rule(RETURN_STATEMENT).is(FlexKeyword.RETURN, b.firstOf(b.sequence(SPACING_NO_LB, NEXT_NOT_LB, LIST_EXPRESSION, EOS), EOS_NO_LB));
        b.rule(THROW_STATEMENT).is(FlexKeyword.THROW, b.firstOf(b.sequence(SPACING_NO_LB, NEXT_NOT_LB, LIST_EXPRESSION, EOS), EOS_NO_LB));
        b.rule(TRY_STATEMENT).is(FlexKeyword.TRY, BLOCK, b.firstOf(b.sequence(CATCH_CLAUSES, b.optional(FlexKeyword.FINALLY, BLOCK)), b.sequence(FlexKeyword.FINALLY, BLOCK)));
        b.rule(CATCH_CLAUSES).is(CATCH_CLAUSE, b.zeroOrMore(CATCH_CLAUSE));
        b.rule(CATCH_CLAUSE).is(FlexKeyword.CATCH, FlexPunctuator.LPARENTHESIS, PARAMETER, FlexPunctuator.RPARENTHESIS, BLOCK);
        b.rule(EXPRESSION).is(b.nextNot(b.firstOf(FlexKeyword.FUNCTION, FlexPunctuator.LCURLYBRACE)), LIST_EXPRESSION);
    }

    private static void directives(LexerlessGrammarBuilder b) {
        b.rule(DIRECTIVE).is(b.firstOf(CONFIG_CONDITION, EMPTY_STATEMENT, ANNOTABLE_DIRECTIVE, STATEMENT, DEFAULT_XML_NAMESPACE_DIRECTIVE, b.sequence(ATTRIBUTES, SPACING_NO_LB, NEXT_NOT_LB, ANNOTABLE_DIRECTIVE), b.sequence(INCLUDE_DIRECTIVE, EOS_NO_LB), b.sequence(IMPORT_DIRECTIVE, EOS_NO_LB), b.sequence(USE_DIRECTIVE, EOS_NO_LB)));
        b.rule(CONFIG_CONDITION).is(IDENTIFIER, FlexPunctuator.DOUBLE_COLON, IDENTIFIER, FlexPunctuator.LCURLYBRACE, DIRECTIVES, FlexPunctuator.RCURLYBRACE);
        b.rule(ANNOTABLE_DIRECTIVE).is(b.firstOf(VARIABLE_DECLARATION_STATEMENT, FUNCTION_DEF, CLASS_DEF, INTERFACE_DEF, NAMESPACE_DEF));
        b.rule(DIRECTIVES).is(b.zeroOrMore(DIRECTIVE));
        b.rule(ATTRIBUTES).is(b.oneOrMore(ATTRIBUTE));
        b.rule(ATTRIBUTE_COMBINATION).is(ATTRIBUTE, SPACING_NO_LB, NEXT_NOT_LB, ATTRIBUTES);
        b.rule(ATTRIBUTE).is(b.firstOf(b.sequence(b.nextNot(FlexKeyword.NAMESPACE), ATTRIBUTE_EXPR), RESERVED_NAMESPACE, b.sequence(FlexPunctuator.LBRAKET, ASSIGNMENT_EXPR, FlexPunctuator.RBRAKET)));
        b.rule(ATTRIBUTE_EXPR).is(IDENTIFIER, b.zeroOrMore(PROPERTY_OPERATOR));
        b.rule(IMPORT_DIRECTIVE).is(FlexKeyword.IMPORT, PACKAGE_NAME, b.optional(FlexPunctuator.DOT, FlexPunctuator.STAR));
        b.rule(INCLUDE_DIRECTIVE).is(FlexKeyword.INCLUDE, SPACING_NO_LB, NEXT_NOT_LB, STRING);
        b.rule(USE_DIRECTIVE).is(FlexKeyword.USE, FlexKeyword.NAMESPACE, LIST_EXPRESSION);
        b.rule(DEFAULT_XML_NAMESPACE_DIRECTIVE).is(FlexKeyword.DEFAULT, SPACING_NO_LB, NEXT_NOT_LB, FlexKeyword.XML, SPACING_NO_LB, NEXT_NOT_LB, FlexKeyword.NAMESPACE, FlexPunctuator.EQUAL1, NON_ASSIGNMENT_EXPR, EOS);
    }

    private static void definitions(LexerlessGrammarBuilder b) {
        b.rule(VARIABLE_DEF).is(VARIABLE_DEF_KIND, VARIABLE_BINDING_LIST);
        b.rule(VARIABLE_DEF_NO_IN).is(VARIABLE_DEF_KIND, VARIABLE_BINDING_LIST_NO_IN);
        b.rule(VARIABLE_DEF_KIND).is(b.firstOf(FlexKeyword.VAR, FlexKeyword.CONST));
        b.rule(VARIABLE_BINDING_LIST).is(VARIABLE_BINDING, b.zeroOrMore(FlexPunctuator.COMMA, VARIABLE_BINDING));
        b.rule(VARIABLE_BINDING_LIST_NO_IN).is(VARIABLE_BINDING_NO_IN, b.zeroOrMore(FlexPunctuator.COMMA, VARIABLE_BINDING_NO_IN));
        b.rule(VARIABLE_BINDING).is(TYPED_IDENTIFIER, b.optional(VARIABLE_INITIALISATION));
        b.rule(VARIABLE_BINDING_NO_IN).is(TYPED_IDENTIFIER_NO_IN, b.optional(VARIABLE_INITIALISATION_NO_IN));
        b.rule(VARIABLE_INITIALISATION).is(FlexPunctuator.EQUAL1, VARIABLE_INITIALISER);
        b.rule(VARIABLE_INITIALISATION_NO_IN).is(FlexPunctuator.EQUAL1, VARIABLE_INITIALISER_NO_IN);
        b.rule(VARIABLE_INITIALISER).is(b.firstOf(ASSIGNMENT_EXPR, ATTRIBUTE_COMBINATION));
        b.rule(VARIABLE_INITIALISER_NO_IN).is(b.firstOf(ASSIGNMENT_EXPR_NO_IN, ATTRIBUTE_COMBINATION));
        b.rule(TYPED_IDENTIFIER).is(b.firstOf(b.sequence(IDENTIFIER, FlexPunctuator.COLON, TYPE_EXPR), IDENTIFIER));
        b.rule(TYPED_IDENTIFIER_NO_IN).is(b.firstOf(b.sequence(IDENTIFIER, FlexPunctuator.COLON, TYPE_EXPR_NO_IN), IDENTIFIER));
        b.rule(FUNCTION_DEF).is(FlexKeyword.FUNCTION, FUNCTION_NAME, FUNCTION_COMMON);
        b.rule(FUNCTION_NAME).is(b.firstOf(b.sequence(FlexKeyword.GET, SPACING_NO_LB, NEXT_NOT_LB, IDENTIFIER), b.sequence(FlexKeyword.SET, SPACING_NO_LB, NEXT_NOT_LB, IDENTIFIER), IDENTIFIER));
        b.rule(FUNCTION_COMMON).is(b.firstOf(b.sequence(FUNCTION_SIGNATURE, BLOCK), b.sequence(FUNCTION_SIGNATURE, EOS)));
        b.rule(FUNCTION_SIGNATURE).is(b.sequence(FlexPunctuator.LPARENTHESIS, b.optional(PARAMETERS), FlexPunctuator.RPARENTHESIS, b.optional(RESULT_TYPE)));
        b.rule(PARAMETERS).is(b.firstOf(b.sequence(PARAMETER, b.zeroOrMore(FlexPunctuator.COMMA, PARAMETER), b.optional(FlexPunctuator.COMMA, REST_PARAMETERS)), REST_PARAMETERS));
        b.rule(PARAMETER).is(b.firstOf(b.sequence(TYPED_IDENTIFIER, FlexPunctuator.EQUAL1, ASSIGNMENT_EXPR), TYPED_IDENTIFIER));
        b.rule(REST_PARAMETERS).is(b.firstOf(b.sequence(FlexPunctuator.TRIPLE_DOTS, TYPED_IDENTIFIER), FlexPunctuator.TRIPLE_DOTS));
        b.rule(RESULT_TYPE).is(FlexPunctuator.COLON, b.firstOf(FlexKeyword.VOID, TYPE_EXPR));
        b.rule(CLASS_DEF).is(FlexKeyword.CLASS, CLASS_NAME, b.optional(INHERITENCE), BLOCK);
        b.rule(CLASS_NAME).is(CLASS_IDENTIFIERS);
        b.rule(CLASS_IDENTIFIERS).is(IDENTIFIER, b.zeroOrMore(b.sequence(FlexPunctuator.DOT, IDENTIFIER)));
        b.rule(INHERITENCE).is(b.firstOf(b.sequence(FlexKeyword.IMPLEMENTS, TYPE_EXPRESSION_LIST), b.sequence(FlexKeyword.EXTENDS, TYPE_EXPR, FlexKeyword.IMPLEMENTS, TYPE_EXPRESSION_LIST), b.sequence(FlexKeyword.EXTENDS, TYPE_EXPR)));
        b.rule(TYPE_EXPRESSION_LIST).is(TYPE_EXPR, b.zeroOrMore(b.sequence(FlexPunctuator.COMMA, TYPE_EXPR)));
        b.rule(INTERFACE_DEF).is(FlexKeyword.INTERFACE, CLASS_NAME, b.optional(EXTENDS_LIST), BLOCK);
        b.rule(EXTENDS_LIST).is(FlexKeyword.EXTENDS, TYPE_EXPRESSION_LIST);
        b.rule(PACKAGE_DEF).is(FlexKeyword.PACKAGE, b.optional(PACKAGE_NAME), BLOCK);
        b.rule(PACKAGE_NAME).is(IDENTIFIER, b.zeroOrMore(FlexPunctuator.DOT, IDENTIFIER));
        b.rule(NAMESPACE_DEF).is(FlexKeyword.NAMESPACE, NAMESPACE_BINDING, EOS);
        b.rule(NAMESPACE_BINDING).is(IDENTIFIER, b.optional(NAMESPACE_INITIALISATION));
        b.rule(NAMESPACE_INITIALISATION).is(FlexPunctuator.EQUAL1, ASSIGNMENT_EXPR);
        b.rule(PROGRAM).is(b.firstOf(b.sequence(PACKAGE_DEF, PROGRAM), DIRECTIVES), SPACING, b.token(GenericTokenType.EOF, b.endOfInput()));
    }

    private static void xml(LexerlessGrammarBuilder b) {
        b.rule(XML_INITIALISER).is(b.firstOf(XML_MARKUP, XML_ELEMENT, b.sequence(FlexPunctuator.LT, FlexPunctuator.GT, XML_ELEMENT_CONTENT, FlexPunctuator.LT, FlexPunctuator.DIV, FlexPunctuator.GT)));
        b.rule(XML_ELEMENT).is(b.firstOf(b.sequence(FlexPunctuator.LT, XML_TAG_CONTENT, b.optional(XML_WHITESPACE), FlexPunctuator.DIV, FlexPunctuator.GT), b.sequence(FlexPunctuator.LT, XML_TAG_CONTENT, b.optional(XML_WHITESPACE), XML_ELEMENT_CONTENT, FlexPunctuator.LT, FlexPunctuator.DIV, XML_TAG_NAME, b.optional(XML_WHITESPACE), FlexPunctuator.GT)));
        b.rule(XML_TAG_CONTENT).is(XML_TAG_NAME, XML_ATTRIBUTES);
        b.rule(XML_TAG_NAME).is(b.firstOf(b.sequence(FlexPunctuator.LCURLYBRACE, EXPRESSION, FlexPunctuator.RCURLYBRACE), XML_NAME));
        b.rule(XML_ATTRIBUTES).is(b.optional(b.firstOf(b.sequence(XML_ATTRIBUTE, XML_ATTRIBUTES), b.sequence(XML_WHITESPACE, FlexPunctuator.LCURLYBRACE, EXPRESSION, FlexPunctuator.RCURLYBRACE))));
        b.rule(XML_ATTRIBUTE).is(b.firstOf(b.sequence(b.zeroOrMore(XML_WHITESPACE), XML_NAME, b.zeroOrMore(XML_WHITESPACE), FlexPunctuator.EQUAL1, b.zeroOrMore(XML_WHITESPACE), FlexPunctuator.LCURLYBRACE, EXPRESSION, FlexPunctuator.RCURLYBRACE), b.sequence(b.zeroOrMore(XML_WHITESPACE), XML_NAME, b.zeroOrMore(XML_WHITESPACE), FlexPunctuator.EQUAL1, b.zeroOrMore(XML_WHITESPACE), XML_ATTRIBUTE_VALUE)));
        b.rule(XML_ELEMENT_CONTENT).is(b.optional(b.firstOf(b.sequence(FlexPunctuator.LCURLYBRACE, EXPRESSION, FlexPunctuator.RCURLYBRACE, XML_ELEMENT_CONTENT), b.sequence(XML_MARKUP, XML_ELEMENT_CONTENT), b.sequence(XML_TEXT, XML_ELEMENT_CONTENT), b.sequence(XML_ELEMENT, XML_ELEMENT_CONTENT))));
        b.rule(XML_MARKUP).is(b.firstOf(XML_COMMENT, XML_CDATA, XML_PI));
        b.rule(XML_COMMENT).is(SPACING, b.regexp("<!--(?:(?!--)[\\s\\S])*?-->"));
        b.rule(XML_CDATA).is(SPACING, b.regexp("<!\\[CDATA\\[(?:(?!]])[\\s\\S])*?]]>"));
        b.rule(XML_PI).is(SPACING, b.regexp("<\\?(?:(?!\\?>)[\\s\\S])*?\\?>"));
        b.rule(XML_TEXT).is(SPACING, b.regexp("[^{<]++"));
        b.rule(XML_NAME).is(SPACING, b.regexp("[\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}_:][\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}\\p{Nd}\\.\\-_:]*"));
        b.rule(XML_ATTRIBUTE_VALUE).is(b.regexp("(\"([^\"]*[//s//S]*)\")|('([^']*[//s//S]*)')"));
        b.rule(XML_WHITESPACE).is(b.regexp("[ \\t\\r\\n]+"));
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        for (FlexKeyword k : FlexKeyword.values()) {
            b.rule(k).is(SPACING, k.getValue(), b.nextNot(IDENTIFIER_PART));
        }
        List<FlexKeyword> keywords = FlexKeyword.keywords();
        Object[] rest = new Object[keywords.size() - 2];
        for (int i = 2; i < keywords.size(); ++i) {
            rest[i - 2] = keywords.get(i);
        }
        b.rule(KEYWORDS).is(b.firstOf(keywords.get(0), keywords.get(1), rest));
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        for (FlexPunctuator p : FlexPunctuator.values()) {
            b.rule(p).is(SPACING, p.getValue());
        }
    }

    private static Object word(LexerlessGrammarBuilder b, String word) {
        return b.sequence(SPACING, word, b.nextNot(IDENTIFIER_PART));
    }
}

