/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.SyntacticEquivalence;

class ConditionalStructure {
    final List<BranchAndContent> branches;
    final boolean allBranchesArePresent;
    final AstNode node;

    static BranchAndContent branchAndContentIf(AstNode branch, AstNode subStatement) {
        return new BranchAndContent(branch, Collections.singletonList(subStatement), ConditionalStructure.isOnelinerSubStatement(subStatement));
    }

    static BranchAndContent branchAndContentSwitch(AstNode branch, List<AstNode> directives) {
        return new BranchAndContent(branch, directives, ConditionalStructure.isOnelinerDirectives(directives));
    }

    ConditionalStructure(AstNode node, List<BranchAndContent> branches, boolean allBranchesArePresent) {
        this.node = node;
        this.branches = branches;
        this.allBranchesArePresent = allBranchesArePresent;
    }

    boolean areAllEquivalentBranches() {
        if (this.branches.isEmpty()) {
            return false;
        }
        BranchAndContent first = this.branches.get(0);
        return this.branches.stream().skip(1L).allMatch(next -> SyntacticEquivalence.areEquivalent(first.content, next.content));
    }

    void forEachBranchDuplication(DuplicatedBranchCallback callback) {
        boolean allEquivalentBranches = this.areAllEquivalentBranches();
        if (this.allBranchesArePresent && allEquivalentBranches) {
            return;
        }
        for (BranchAndContent branch1 : this.branches) {
            if (branch1.oneLiner && !allEquivalentBranches) continue;
            for (BranchAndContent branch2 : this.branches) {
                if (branch1 == branch2) break;
                if (!SyntacticEquivalence.areEquivalent(branch1.content, branch2.content)) continue;
                callback.accept(branch1.branch, branch2.branch);
            }
        }
    }

    static boolean isOnelinerNonBlock(AstNode nonBlock) {
        List<Token> tokens = nonBlock.getTokens();
        if (!tokens.isEmpty()) {
            return tokens.get(0).isOnSameLineThan(tokens.get(tokens.size() - 1));
        }
        return false;
    }

    static boolean isOnelinerSubStatement(AstNode node) {
        AstNode grandchild;
        AstNode child = node.getFirstChild(FlexGrammar.STATEMENT);
        if (child != null && (grandchild = child.getFirstChild(FlexGrammar.BLOCK)) != null) {
            return ConditionalStructure.isOnelinerDirectives(grandchild.getFirstChild(FlexGrammar.DIRECTIVES).getChildren(FlexGrammar.DIRECTIVE));
        }
        return ConditionalStructure.isOnelinerNonBlock(node);
    }

    static boolean isOnelinerDirectives(List<AstNode> directives) {
        if (directives.isEmpty()) {
            return true;
        }
        Token firstToken = directives.get(0).getTokens().get(0);
        Token lastToken = directives.get(directives.size() - 1).getLastToken();
        return firstToken.isOnSameLineThan(lastToken);
    }

    static ConditionalStructure ifStatement(AstNode node, Set<AstNode> visitedIfStatements) {
        ArrayList<BranchAndContent> branches = new ArrayList<BranchAndContent>();
        boolean allBranchesArePresent = false;
        branches.add(ConditionalStructure.branchAndContentIf(node, node.getFirstChild(FlexGrammar.SUB_STATEMENT)));
        AstNode currentIfStatement = node;
        while (currentIfStatement.hasDirectChildren(FlexKeyword.ELSE)) {
            AstNode elseStatement = currentIfStatement.getLastChild(FlexGrammar.SUB_STATEMENT).getFirstChild(FlexGrammar.STATEMENT);
            if (elseStatement != null && elseStatement.hasDirectChildren(FlexGrammar.IF_STATEMENT)) {
                currentIfStatement = elseStatement.getFirstChild(FlexGrammar.IF_STATEMENT);
                visitedIfStatements.add(currentIfStatement);
                branches.add(ConditionalStructure.branchAndContentIf(currentIfStatement, currentIfStatement.getFirstChild(FlexGrammar.SUB_STATEMENT)));
                continue;
            }
            AstNode theElse = currentIfStatement.getFirstChild(FlexKeyword.ELSE);
            if (theElse != null) {
                branches.add(ConditionalStructure.branchAndContentIf(theElse, currentIfStatement.getLastChild(FlexGrammar.SUB_STATEMENT)));
            }
            allBranchesArePresent = true;
            break;
        }
        return new ConditionalStructure(node, branches, allBranchesArePresent);
    }

    static ConditionalStructure switchStatement(AstNode node) {
        ArrayList<BranchAndContent> branches = new ArrayList<BranchAndContent>();
        boolean allBranchesArePresent = false;
        for (AstNode caseElement : node.getChildren(FlexGrammar.CASE_ELEMENT)) {
            List<AstNode> directives = caseElement.getChildren(FlexGrammar.DIRECTIVE);
            if (!directives.isEmpty() && ConditionalStructure.isBreakStatement(directives.get(directives.size() - 1).getFirstChild())) {
                directives = directives.subList(0, directives.size() - 1);
            }
            branches.add(ConditionalStructure.branchAndContentSwitch(caseElement, directives));
            for (AstNode caseLabelNode : caseElement.getChildren(FlexGrammar.CASE_LABEL)) {
                if (!caseLabelNode.hasDirectChildren(FlexKeyword.DEFAULT)) continue;
                allBranchesArePresent = true;
            }
        }
        return new ConditionalStructure(node, branches, allBranchesArePresent);
    }

    private static boolean isBreakStatement(AstNode node) {
        return node.is(FlexGrammar.STATEMENT) && node.hasDirectChildren(FlexGrammar.BREAK_STATEMENT);
    }

    AstNode getNode() {
        return this.node;
    }

    @FunctionalInterface
    static interface DuplicatedBranchCallback
    extends BiConsumer<AstNode, AstNode> {
        @Override
        public void accept(AstNode var1, AstNode var2);
    }

    static class BranchAndContent {
        AstNode branch;
        List<AstNode> content;
        boolean oneLiner;

        BranchAndContent(AstNode branch, List<AstNode> content, boolean oneLiner) {
            this.branch = branch;
            this.content = content;
            this.oneLiner = oneLiner;
        }
    }
}

