/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;

@Rule(key="LineLength")
public class LineLengthCheck
extends FlexCheck {
    private static final int DEFAULT_MAXIMUM_LINE_LENHGTH = 80;
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="80")
    public int maximumLineLength = 80;

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.emptyList();
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        String fileContent = this.getContext().fileContent();
        String[] lines = fileContent.split("\\r?\\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() <= this.maximumLineLength) continue;
            this.addIssueAtLine(MessageFormat.format("Split this {0} characters long line (which is greater than {1} authorized).", line.length(), this.maximumLineLength), i + 1);
        }
    }
}

