/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Function;
import org.sonar.flex.checks.utils.Modifiers;
import org.sonar.flex.checks.utils.Variable;

@Rule(key="S1117")
public class LocalVarShadowsFieldCheck
extends FlexCheck {
    private Deque<ClassState> classStack = new ArrayDeque<ClassState>();
    private int functionNestedLevel;
    private static final String MESSAGE = "Rename \"{0}\" which hides the field declared at line {1}.";

    @Override
    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.CLASS_DEF, FlexGrammar.FUNCTION_DEF, FlexGrammar.VARIABLE_DECLARATION_STATEMENT);
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        this.classStack.clear();
        this.functionNestedLevel = 0;
    }

    @Override
    public void visitNode(AstNode node) {
        if (node.is(FlexGrammar.CLASS_DEF)) {
            this.classStack.push(new ClassState(node));
        } else if (this.isClassFunctionNotConstructor(node) && !LocalVarShadowsFieldCheck.isAccessor(node) && !LocalVarShadowsFieldCheck.isStatic(node)) {
            ++this.functionNestedLevel;
        } else if (!this.classStack.isEmpty() && this.functionNestedLevel > 0 && node.is(FlexGrammar.VARIABLE_DECLARATION_STATEMENT)) {
            this.checkVariableNames(node);
        }
    }

    private boolean isClassFunctionNotConstructor(AstNode node) {
        return !this.classStack.isEmpty() && node.is(FlexGrammar.FUNCTION_DEF) && !Function.isConstructor(node, this.classStack.peek().getClassName());
    }

    private static boolean isStatic(AstNode functionDef) {
        return Modifiers.getModifiers(functionDef.getParent().getPreviousAstNode()).contains(FlexKeyword.STATIC);
    }

    private static boolean isAccessor(AstNode functionDef) {
        String functionName = Function.getName(functionDef);
        return Function.isAccessor(functionDef) || functionName.length() > 2 && "set".equals(functionName.substring(0, 3));
    }

    private void checkVariableNames(AstNode varDeclStatement) {
        for (AstNode identifier : Variable.getDeclaredIdentifiers(varDeclStatement)) {
            String varName = identifier.getTokenValue();
            AstNode field = this.classStack.peek().getFieldNamed(varName);
            if (field == null) continue;
            this.addIssue(MessageFormat.format(MESSAGE, varName, field.getToken().getLine()), identifier);
        }
    }

    @Override
    public void leaveNode(AstNode astNode) {
        if (astNode.is(FlexGrammar.CLASS_DEF)) {
            this.classStack.pop();
        } else if (!this.classStack.isEmpty() && astNode.is(FlexGrammar.FUNCTION_DEF) && this.functionNestedLevel > 0) {
            --this.functionNestedLevel;
        }
    }

    private static class ClassState {
        private final Map<String, AstNode> classFields;
        private final String className;

        public ClassState(AstNode classDef) {
            this.className = Clazz.getName(classDef);
            this.classFields = Maps.newHashMap();
            this.initFieldsMap(classDef);
        }

        private void initFieldsMap(AstNode classDef) {
            for (AstNode varDeclStatement : Clazz.getFields(classDef)) {
                for (AstNode identifier : Variable.getDeclaredIdentifiers(varDeclStatement)) {
                    this.classFields.put(identifier.getTokenValue(), identifier);
                }
            }
        }

        public AstNode getFieldNamed(String name) {
            return this.classFields.get(name);
        }

        public String getClassName() {
            return this.className;
        }
    }
}

