/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Iterables;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="NonEmptyCaseWithoutBreak")
public class NonEmptyCaseWithoutBreakCheck
extends FlexCheck {
    private static final AstNodeType[] JUMP_NODES = new AstNodeType[]{FlexGrammar.BREAK_STATEMENT, FlexGrammar.RETURN_STATEMENT, FlexGrammar.THROW_STATEMENT, FlexGrammar.CONTINUE_STATEMENT};

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CASE_ELEMENT);
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (NonEmptyCaseWithoutBreakCheck.isLastCaseElement(astNode)) {
            return;
        }
        int jumpStmtNumber = astNode.getDescendants(JUMP_NODES).size();
        if (jumpStmtNumber < 2) {
            AstNode directive = astNode.getLastChild();
            this.visitLastDirective(astNode, directive);
        }
    }

    private static boolean isLastCaseElement(AstNode astNode) {
        return astNode.getNextSibling().isNot(FlexGrammar.CASE_ELEMENT);
    }

    private void visitLastDirective(AstNode astNode, AstNode directive) {
        if (NonEmptyCaseWithoutBreakCheck.isBlock(directive)) {
            this.visitLastDirective(astNode, directive.getFirstChild().getFirstChild().getLastChild());
            return;
        }
        if (directive.getFirstChild().is(FlexGrammar.STATEMENT) && directive.getFirstChild().getFirstChild().isNot(JUMP_NODES)) {
            this.addIssue("Last statement in this switch-clause should be an unconditional break.", Iterables.getLast(astNode.getChildren(FlexGrammar.CASE_LABEL)));
        }
    }

    private static boolean isBlock(AstNode directive) {
        return directive.getNumberOfChildren() == 1 && directive.getFirstChild().is(FlexGrammar.STATEMENT) && directive.getFirstChild().getNumberOfChildren() == 1 && directive.getFirstChild().getFirstChild().is(FlexGrammar.BLOCK);
    }
}

