/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Function;

public final class Clazz {
    private Clazz() {
    }

    public static List<AstNode> getDirectives(AstNode classDefNode) {
        Preconditions.checkArgument(classDefNode.is(FlexGrammar.CLASS_DEF));
        return classDefNode.getFirstChild(FlexGrammar.BLOCK).getFirstChild(FlexGrammar.DIRECTIVES).getChildren(FlexGrammar.DIRECTIVE);
    }

    public static List<AstNode> getFields(AstNode classDefNode) {
        Preconditions.checkArgument(classDefNode.is(FlexGrammar.CLASS_DEF));
        ArrayList<AstNode> fields = Lists.newArrayList();
        for (AstNode directive : classDefNode.getFirstChild(FlexGrammar.BLOCK).getFirstChild(FlexGrammar.DIRECTIVES).getChildren()) {
            AstNode fieldDef = Clazz.getFieldDefinition(directive);
            if (fieldDef == null) continue;
            fields.add(fieldDef);
        }
        return fields;
    }

    public static String getName(AstNode classDefNode) {
        Preconditions.checkArgument(classDefNode.is(FlexGrammar.CLASS_DEF));
        return classDefNode.getFirstChild(FlexGrammar.CLASS_NAME).getFirstChild(FlexGrammar.CLASS_IDENTIFIERS).getLastChild().getTokenValue();
    }

    public static AstNode getConstructor(AstNode classDefNode) {
        Preconditions.checkArgument(classDefNode.is(FlexGrammar.CLASS_DEF));
        String className = Clazz.getName(classDefNode);
        for (AstNode directive : classDefNode.getFirstChild(FlexGrammar.BLOCK).getFirstChild(FlexGrammar.DIRECTIVES).getChildren()) {
            AstNode functionDef = Clazz.getFunctionDefinition(directive.getFirstChild(FlexGrammar.ANNOTABLE_DIRECTIVE));
            if (functionDef == null || !Function.isConstructor(functionDef, className)) continue;
            return functionDef;
        }
        return null;
    }

    private static AstNode getFieldDefinition(AstNode directive) {
        Preconditions.checkArgument(directive.is(FlexGrammar.DIRECTIVE));
        AstNode annotableDir = directive.getFirstChild(FlexGrammar.ANNOTABLE_DIRECTIVE);
        return annotableDir == null ? null : annotableDir.getFirstChild(FlexGrammar.VARIABLE_DECLARATION_STATEMENT);
    }

    private static AstNode getFunctionDefinition(@Nullable AstNode annotableDir) {
        return annotableDir != null && annotableDir.is(FlexGrammar.ANNOTABLE_DIRECTIVE) && annotableDir.getFirstChild().is(FlexGrammar.FUNCTION_DEF) ? annotableDir.getFirstChild() : null;
    }

    public static List<AstNode> getFunctions(AstNode classDefNode) {
        Preconditions.checkArgument(classDefNode.is(FlexGrammar.CLASS_DEF));
        ArrayList<AstNode> functions = Lists.newArrayList();
        for (AstNode directive : classDefNode.getFirstChild(FlexGrammar.BLOCK).getFirstChild(FlexGrammar.DIRECTIVES).getChildren()) {
            AstNode functionDef = Clazz.getFunctionDefinition(directive.getFirstChild(FlexGrammar.ANNOTABLE_DIRECTIVE));
            if (functionDef == null) continue;
            functions.add(functionDef);
        }
        return functions;
    }
}

