/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.flex.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.resources.AbstractLanguage;

public class Flex
extends AbstractLanguage {
    public static final String NAME = "Flex";
    public static final String KEY = "flex";
    public static final String DEFAULT_FILE_SUFFIXES = "as";
    private final Configuration config;

    public Flex(Configuration config) {
        super(KEY, NAME);
        this.config = config;
    }

    public String[] getFileSuffixes() {
        String[] suffixes = Flex.filterEmptyStrings(this.config.getStringArray("sonar.flex.file.suffixes"));
        if (suffixes.length == 0) {
            suffixes = StringUtils.split(DEFAULT_FILE_SUFFIXES, ",");
        }
        return suffixes;
    }

    private static String[] filterEmptyStrings(String[] stringArray) {
        ArrayList<String> nonEmptyStrings = Lists.newArrayList();
        for (String string : stringArray) {
            if (!StringUtils.isNotBlank(string.trim())) continue;
            nonEmptyStrings.add(string.trim());
        }
        return nonEmptyStrings.toArray(new String[nonEmptyStrings.size()]);
    }
}

