/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.util.Locale;
import javax.xml.xpath.XPathExpression;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.Node;

public abstract class CommentContainsPatternChecker
extends SimpleXPathBasedCheck {
    private final String pattern;
    private final String message;
    private final XPathExpression xPathExpression = this.getXPathExpression("//comment()");

    protected CommentContainsPatternChecker(String pattern, String message) {
        this.pattern = pattern.toLowerCase(Locale.ENGLISH);
        this.message = message;
    }

    @Override
    public final void scanFile(XmlFile file) {
        this.checkIfCommentContainsPattern(file);
    }

    private static boolean isLetterAround(String line, String pattern) {
        int start = line.indexOf(pattern);
        int end = start + pattern.length();
        boolean pre = start > 0 && Character.isLetter(line.charAt(start - 1));
        boolean post = end < line.length() - 1 && Character.isLetter(line.charAt(end));
        return pre || post;
    }

    private void checkIfCommentContainsPattern(XmlFile file) {
        this.evaluateAsList(this.xPathExpression, file.getDocument()).forEach(node -> {
            String comment = node.getNodeValue().toLowerCase(Locale.ENGLISH);
            if (comment.contains(this.pattern) && !CommentContainsPatternChecker.isLetterAround(comment, this.pattern)) {
                this.reportIssue((Node)node, this.message);
            }
        });
    }
}

