/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.web;

import java.util.List;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.security.web.AbstractWebXmlCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.w3c.dom.Node;

@Rule(key="S3330")
public class HttpOnlyOnCookiesCheck
extends AbstractWebXmlCheck {
    private XPathExpression sessionConfigCookieConfigExpression = XPathBuilder.forExpression("/n:web-app/n:session-config/n:cookie-config").withNamespace("n", "http://xmlns.jcp.org/xml/ns/javaee").build();
    private XPathExpression httpOnlyExpression = XPathBuilder.forExpression("n:http-only").withNamespace("n", "http://xmlns.jcp.org/xml/ns/javaee").build();

    @Override
    void scanWebXml(XmlFile file) {
        this.evaluateAsList(this.sessionConfigCookieConfigExpression, file.getDocument()).forEach(this::checkHttpOnly);
    }

    private void checkHttpOnly(Node cookieConfig) {
        List<Node> httpOnlyNodes = this.evaluateAsList(this.httpOnlyExpression, cookieConfig);
        if (httpOnlyNodes.isEmpty()) {
            this.reportIssue(cookieConfig, "<http-only> tag is missing and should be set to true.");
        } else {
            httpOnlyNodes.stream().filter(HttpOnlyOnCookiesCheck::isNotSetToTrue).forEach(this::reportWrongValue);
        }
    }

    private static boolean isNotSetToTrue(Node node) {
        return !"true".equals(node.getTextContent());
    }

    private void reportWrongValue(Node node) {
        this.reportIssue(node, "<http-only> tag should be set to true.");
    }
}

