/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings.put;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateSettingsAction
extends AcknowledgedTransportMasterNodeAction<UpdateSettingsRequest> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateSettingsAction.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TransportUpdateSettingsAction.class);
    private final MetadataUpdateSettingsService updateSettingsService;
    private final SystemIndices systemIndices;

    @Inject
    public TransportUpdateSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataUpdateSettingsService updateSettingsService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super("indices:admin/settings/update", transportService, clusterService, threadPool, actionFilters, UpdateSettingsRequest::new, indexNameExpressionResolver, "same");
        this.updateSettingsService = updateSettingsService;
        this.systemIndices = systemIndices;
    }

    @Override
    protected ClusterBlockException checkBlock(UpdateSettingsRequest request, ClusterState state) {
        ClusterBlockException globalBlock = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        if (globalBlock != null) {
            return globalBlock;
        }
        if (request.settings().size() == 1 && IndexMetadata.INDEX_BLOCKS_METADATA_SETTING.exists(request.settings()) || IndexMetadata.INDEX_READ_ONLY_SETTING.exists(request.settings()) || IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING.exists(request.settings())) {
            return null;
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected void masterOperation(UpdateSettingsRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        final Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request);
        Settings requestSettings = request.settings();
        Map<String, List<String>> systemIndexViolations = this.checkForSystemIndexViolations(concreteIndices, request);
        if (!systemIndexViolations.isEmpty()) {
            String message = "Overriding settings on system indices: " + systemIndexViolations.entrySet().stream().map(entry -> "[" + (String)entry.getKey() + "] -> " + entry.getValue()).collect(Collectors.joining(", ")) + ". This will not work in the next major version";
            deprecationLogger.deprecate(DeprecationCategory.API, "open_system_index_access", message, new Object[0]);
        }
        UpdateSettingsClusterStateUpdateRequest clusterStateUpdateRequest = (UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)((UpdateSettingsClusterStateUpdateRequest)new UpdateSettingsClusterStateUpdateRequest().indices(concreteIndices)).settings(requestSettings).setPreserveExisting(request.isPreserveExisting()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout());
        this.updateSettingsService.updateSettings(clusterStateUpdateRequest, new ActionListener<AcknowledgedResponse>(){

            @Override
            public void onResponse(AcknowledgedResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void onFailure(Exception t) {
                logger.debug(() -> new ParameterizedMessage("failed to update settings on indices [{}]", (Object)concreteIndices), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    private Map<String, List<String>> checkForSystemIndexViolations(Index[] concreteIndices, UpdateSettingsRequest request) {
        if (!Strings.isNullOrEmpty(request.origin())) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> violationsByIndex = new HashMap<String, List<String>>();
        Settings requestSettings = request.settings();
        for (Index index : concreteIndices) {
            SystemIndexDescriptor descriptor = this.systemIndices.findMatchingDescriptor(index.getName());
            if (descriptor == null || !descriptor.isAutomaticallyManaged()) continue;
            Settings descriptorSettings = descriptor.getSettings();
            ArrayList<String> failedKeys = new ArrayList<String>();
            for (String key : requestSettings.keySet()) {
                String actualValue;
                String expectedValue = descriptorSettings.get(key);
                if (Objects.equals(expectedValue, actualValue = requestSettings.get(key))) continue;
                failedKeys.add(key);
            }
            if (failedKeys.isEmpty()) continue;
            violationsByIndex.put(descriptor.getIndexPattern(), failedKeys);
        }
        return violationsByIndex;
    }
}

