/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.BytesReferenceStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.util.concurrent.RefCounted;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class ReleasableBytesReference
implements RefCounted,
Releasable,
BytesReference {
    public static final Releasable NO_OP = () -> {};
    private final BytesReference delegate;
    private final AbstractRefCounted refCounted;

    public ReleasableBytesReference(BytesReference delegate, Releasable releasable) {
        this.delegate = delegate;
        this.refCounted = new RefCountedReleasable(releasable);
    }

    private ReleasableBytesReference(BytesReference delegate, AbstractRefCounted refCounted) {
        this.delegate = delegate;
        this.refCounted = refCounted;
        refCounted.incRef();
    }

    public static ReleasableBytesReference wrap(BytesReference reference) {
        return new ReleasableBytesReference(reference, NO_OP);
    }

    public int refCount() {
        return this.refCounted.refCount();
    }

    @Override
    public void incRef() {
        this.refCounted.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.refCounted.tryIncRef();
    }

    @Override
    public boolean decRef() {
        return this.refCounted.decRef();
    }

    public ReleasableBytesReference retain() {
        this.refCounted.incRef();
        return this;
    }

    public ReleasableBytesReference retainedSlice(int from, int length) {
        if (from == 0 && this.length() == length) {
            return this.retain();
        }
        return new ReleasableBytesReference(this.delegate.slice(from, length), this.refCounted);
    }

    @Override
    public void close() {
        this.refCounted.decRef();
    }

    @Override
    public byte get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int getInt(int index) {
        return this.delegate.getInt(index);
    }

    @Override
    public int indexOf(byte marker, int from) {
        return this.delegate.indexOf(marker, from);
    }

    @Override
    public int length() {
        return this.delegate.length();
    }

    @Override
    public BytesReference slice(int from, int length) {
        assert (this.refCount() > 0);
        return this.delegate.slice(from, length);
    }

    @Override
    public long ramBytesUsed() {
        return this.delegate.ramBytesUsed();
    }

    @Override
    public StreamInput streamInput() throws IOException {
        assert (this.refCount() > 0);
        return new BytesReferenceStreamInput(this){

            @Override
            public ReleasableBytesReference readReleasableBytesReference() throws IOException {
                int len = this.readArraySize();
                ReleasableBytesReference result = ReleasableBytesReference.this.retainedSlice(this.offset(), len);
                this.skip(len);
                return result;
            }
        };
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        assert (this.refCount() > 0);
        this.delegate.writeTo(os);
    }

    @Override
    public String utf8ToString() {
        assert (this.refCount() > 0);
        return this.delegate.utf8ToString();
    }

    @Override
    public BytesRef toBytesRef() {
        assert (this.refCount() > 0);
        return this.delegate.toBytesRef();
    }

    @Override
    public BytesRefIterator iterator() {
        assert (this.refCount() > 0);
        return this.delegate.iterator();
    }

    @Override
    public int compareTo(BytesReference o) {
        return this.delegate.compareTo(o);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        assert (this.refCount() > 0);
        return this.delegate.toXContent(builder, params);
    }

    @Override
    public boolean isFragment() {
        return this.delegate.isFragment();
    }

    public boolean equals(Object obj) {
        assert (this.refCount() > 0);
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        assert (this.refCount() > 0);
        return this.delegate.hashCode();
    }

    private static final class RefCountedReleasable
    extends AbstractRefCounted {
        private final Releasable releasable;

        RefCountedReleasable(Releasable releasable) {
            super("bytes-reference");
            this.releasable = releasable;
        }

        @Override
        protected void closeInternal() {
            this.releasable.close();
        }
    }
}

