/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;

public class FilterableTermsEnum
extends TermsEnum {
    static final String UNSUPPORTED_MESSAGE = "This TermsEnum only supports #seekExact(BytesRef) as well as #docFreq() and #totalTermFreq()";
    protected static final int NOT_FOUND = -1;
    private final Holder[] enums;
    protected int currentDocFreq = 0;
    protected long currentTotalTermFreq = 0L;
    protected BytesRef current;
    protected final int docsEnumFlag;

    public FilterableTermsEnum(IndexReader reader, String field, int docsEnumFlag, @Nullable Query filter) throws IOException {
        Weight weight;
        if (docsEnumFlag != 8 && docsEnumFlag != 0) {
            throw new IllegalArgumentException("invalid docsEnumFlag of " + docsEnumFlag);
        }
        this.docsEnumFlag = docsEnumFlag;
        List<LeafReaderContext> leaves = reader.leaves();
        ArrayList<Holder> enums = new ArrayList<Holder>(leaves.size());
        if (filter == null) {
            weight = null;
        } else {
            IndexSearcher searcher = new IndexSearcher(reader);
            searcher.setQueryCache(null);
            weight = searcher.createWeight(searcher.rewrite(filter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        for (LeafReaderContext context : leaves) {
            TermsEnum termsEnum;
            Terms terms = context.reader().terms(field);
            if (terms == null || (termsEnum = terms.iterator()) == null) continue;
            BitSet bits = null;
            if (weight != null) {
                Scorer scorer = weight.scorer(context);
                if (scorer == null) continue;
                DocIdSetIterator docs = scorer.iterator();
                final Bits liveDocs = context.reader().getLiveDocs();
                if (liveDocs != null) {
                    docs = new FilteredDocIdSetIterator(docs){

                        @Override
                        protected boolean match(int doc) {
                            return liveDocs.get(doc);
                        }
                    };
                }
                bits = BitSet.of(docs, context.reader().maxDoc());
            }
            enums.add(new Holder(termsEnum, bits));
        }
        this.enums = enums.toArray(new Holder[enums.size()]);
    }

    @Override
    public BytesRef term() throws IOException {
        return this.current;
    }

    @Override
    public AttributeSource attributes() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public boolean seekExact(BytesRef text) throws IOException {
        int docFreq = 0;
        long totalTermFreq = 0L;
        for (Holder anEnum : this.enums) {
            int docId;
            if (!anEnum.termsEnum.seekExact(text)) continue;
            if (anEnum.bits == null) {
                docFreq += anEnum.termsEnum.docFreq();
                if (this.docsEnumFlag != 8) continue;
                long leafTotalTermFreq = anEnum.termsEnum.totalTermFreq();
                if (totalTermFreq == -1L || leafTotalTermFreq == -1L) {
                    totalTermFreq = -1L;
                    continue;
                }
                totalTermFreq += leafTotalTermFreq;
                continue;
            }
            PostingsEnum docsEnum = anEnum.docsEnum = anEnum.termsEnum.postings(anEnum.docsEnum, this.docsEnumFlag);
            if (this.docsEnumFlag == 8) {
                docId = docsEnum.nextDoc();
                while (docId != Integer.MAX_VALUE) {
                    if (anEnum.bits == null || anEnum.bits.get(docId)) {
                        ++docFreq;
                        totalTermFreq += (long)docsEnum.freq();
                    }
                    docId = docsEnum.nextDoc();
                }
                continue;
            }
            docId = docsEnum.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                if (anEnum.bits == null || anEnum.bits.get(docId)) {
                    ++docFreq;
                }
                docId = docsEnum.nextDoc();
            }
        }
        if (docFreq > 0) {
            this.currentDocFreq = docFreq;
            this.currentTotalTermFreq = totalTermFreq;
            this.current = text;
            return true;
        }
        this.currentDocFreq = -1;
        this.currentTotalTermFreq = -1L;
        this.current = null;
        return false;
    }

    @Override
    public int docFreq() throws IOException {
        return this.currentDocFreq;
    }

    @Override
    public long totalTermFreq() throws IOException {
        return this.currentTotalTermFreq;
    }

    @Override
    public void seekExact(long ord) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void seekExact(BytesRef term, TermState state) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public TermState termState() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public long ord() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public ImpactsEnum impacts(int flags) throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public BytesRef next() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    static class Holder {
        final TermsEnum termsEnum;
        @Nullable
        PostingsEnum docsEnum;
        @Nullable
        final Bits bits;

        Holder(TermsEnum termsEnum, Bits bits) {
            this.termsEnum = termsEnum;
            this.bits = bits;
        }
    }
}

