/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableFieldType;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.AbstractXContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;

public abstract class FieldMapper
extends Mapper
implements Cloneable {
    public static final Setting<Boolean> IGNORE_MALFORMED_SETTING = Setting.boolSetting("index.mapping.ignore_malformed", false, Setting.Property.IndexScope);
    public static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", false, Setting.Property.IndexScope);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(FieldMapper.class);
    protected final MappedFieldType mappedFieldType;
    protected final Map<String, NamedAnalyzer> indexAnalyzers;
    protected final MultiFields multiFields;
    protected final CopyTo copyTo;

    protected FieldMapper(String simpleName, MappedFieldType mappedFieldType, MultiFields multiFields, CopyTo copyTo) {
        this(simpleName, mappedFieldType, Collections.emptyMap(), multiFields, copyTo);
    }

    protected FieldMapper(String simpleName, MappedFieldType mappedFieldType, NamedAnalyzer indexAnalyzer, MultiFields multiFields, CopyTo copyTo) {
        this(simpleName, mappedFieldType, Collections.singletonMap(mappedFieldType.name(), indexAnalyzer), multiFields, copyTo);
    }

    protected FieldMapper(String simpleName, MappedFieldType mappedFieldType, Map<String, NamedAnalyzer> indexAnalyzers, MultiFields multiFields, CopyTo copyTo) {
        super(simpleName);
        if (mappedFieldType.name().isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty string");
        }
        this.mappedFieldType = mappedFieldType;
        this.indexAnalyzers = indexAnalyzers;
        this.multiFields = multiFields;
        this.copyTo = Objects.requireNonNull(copyTo);
    }

    @Override
    public String name() {
        return this.fieldType().name();
    }

    @Override
    public String typeName() {
        return this.mappedFieldType.typeName();
    }

    public MappedFieldType fieldType() {
        return this.mappedFieldType;
    }

    public CopyTo copyTo() {
        return this.copyTo;
    }

    public MultiFields multiFields() {
        return this.multiFields;
    }

    public boolean parsesArrayValue() {
        return false;
    }

    public void parse(ParseContext context) throws IOException {
        try {
            this.parseCreateField(context);
        }
        catch (Exception e) {
            String valuePreview = "";
            try {
                XContentParser parser = context.parser();
                Object complexValue = AbstractXContentParser.readValue(parser, HashMap::new);
                valuePreview = complexValue == null ? "null" : complexValue.toString();
            }
            catch (Exception innerException) {
                throw new MapperParsingException("failed to parse field [{}] of type [{}] in document with id '{}'. Could not parse field value preview,", (Throwable)e, this.fieldType().name(), this.fieldType().typeName(), context.sourceToParse().id());
            }
            throw new MapperParsingException("failed to parse field [{}] of type [{}] in document with id '{}'. Preview of field's value: '{}'", (Throwable)e, this.fieldType().name(), this.fieldType().typeName(), context.sourceToParse().id(), valuePreview);
        }
        this.multiFields.parse(this, context);
    }

    protected abstract void parseCreateField(ParseContext var1) throws IOException;

    protected final void createFieldNamesField(ParseContext context) {
        FieldNamesFieldMapper.FieldNamesFieldType fieldNamesFieldType;
        assert (!this.fieldType().hasDocValues()) : "_field_names should only be used when doc_values are turned off";
        FieldNamesFieldMapper fieldNamesFieldMapper = (FieldNamesFieldMapper)context.getMetadataMapper("_field_names");
        if (fieldNamesFieldMapper != null && (fieldNamesFieldType = fieldNamesFieldMapper.fieldType()) != null && fieldNamesFieldType.isEnabled()) {
            for (String fieldName : FieldNamesFieldMapper.extractFieldNames(this.fieldType().name())) {
                context.doc().add(new Field("_field_names", fieldName, (IndexableFieldType)FieldNamesFieldMapper.Defaults.FIELD_TYPE));
            }
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        final Iterator<FieldMapper> multiFieldsIterator = this.multiFields.iterator();
        return new Iterator<Mapper>(){

            @Override
            public boolean hasNext() {
                return multiFieldsIterator.hasNext();
            }

            @Override
            public Mapper next() {
                return (Mapper)multiFieldsIterator.next();
            }
        };
    }

    @Override
    public final void validate(MappingLookup mappers) {
        if (this.copyTo() != null && !this.copyTo().copyToFields().isEmpty()) {
            if (mappers.isMultiField(this.name())) {
                throw new IllegalArgumentException("[copy_to] may not be used to copy from a multi-field: [" + this.name() + "]");
            }
            String sourceScope = mappers.getNestedScope(this.name());
            for (String copyTo : this.copyTo().copyToFields()) {
                if (mappers.isMultiField(copyTo)) {
                    throw new IllegalArgumentException("[copy_to] may not be used to copy to a multi-field: [" + copyTo + "]");
                }
                if (mappers.isObjectField(copyTo)) {
                    throw new IllegalArgumentException("Cannot copy to field [" + copyTo + "] since it is mapped as an object");
                }
                String targetScope = mappers.getNestedScope(copyTo);
                FieldMapper.checkNestedScopeCompatibility(sourceScope, targetScope);
            }
        }
        for (Mapper multiField : this.multiFields()) {
            multiField.validate(mappers);
        }
        this.doValidate(mappers);
    }

    protected void doValidate(MappingLookup mappers) {
    }

    private static void checkNestedScopeCompatibility(String source, String target) {
        boolean targetIsParentOfSource;
        if (source == null || target == null) {
            targetIsParentOfSource = target == null;
        } else {
            boolean bl = targetIsParentOfSource = source.equals(target) || source.startsWith(target + ".");
        }
        if (!targetIsParentOfSource) {
            throw new IllegalArgumentException("Illegal combination of [copy_to] and [nested] mappings: [copy_to] may only copy data to the current nested document or any of its parents, however one [copy_to] directive is trying to copy data from nested object [" + source + "] to [" + target + "]");
        }
    }

    public abstract Builder getMergeBuilder();

    @Override
    public final FieldMapper merge(Mapper mergeWith) {
        if (!(mergeWith instanceof FieldMapper)) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] cannot be changed from type [" + this.contentType() + "] to [" + mergeWith.getClass().getSimpleName() + "]");
        }
        this.checkIncomingMergeType((FieldMapper)mergeWith);
        Builder builder = this.getMergeBuilder();
        if (builder == null) {
            return (FieldMapper)mergeWith;
        }
        Conflicts conflicts = new Conflicts(this.name());
        builder.merge((FieldMapper)mergeWith, conflicts);
        conflicts.check();
        return builder.build(Builder.parentPath(this.name()));
    }

    protected void checkIncomingMergeType(FieldMapper mergeWith) {
        if (!Objects.equals(this.getClass(), mergeWith.getClass())) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] cannot be changed from type [" + this.contentType() + "] to [" + mergeWith.contentType() + "]");
        }
        if (!Objects.equals(this.contentType(), mergeWith.contentType())) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] cannot be changed from type [" + this.contentType() + "] to [" + mergeWith.contentType() + "]");
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.simpleName());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        this.doXContentBody(builder, includeDefaults, params);
        return builder.endObject();
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        this.getMergeBuilder().toXContent(builder, includeDefaults);
        this.multiFields.toXContent(builder, params);
        this.copyTo.toXContent(builder, params);
    }

    protected abstract String contentType();

    public final Map<String, NamedAnalyzer> indexAnalyzers() {
        return this.indexAnalyzers;
    }

    public static class MultiFields
    implements Iterable<FieldMapper>,
    ToXContent {
        private final Map<String, FieldMapper> mappers;

        public static MultiFields empty() {
            return new MultiFields(Collections.emptyMap());
        }

        private MultiFields(Map<String, FieldMapper> mappers) {
            this.mappers = mappers;
        }

        public void parse(FieldMapper mainField, ParseContext context) throws IOException {
            if (this.mappers.isEmpty()) {
                return;
            }
            context = context.createMultiFieldContext();
            context.path().add(mainField.simpleName());
            for (FieldMapper mapper : this.mappers.values()) {
                mapper.parse(context);
            }
            context.path().remove();
        }

        public MultiFields merge(MultiFields mergeWith) {
            HashMap<String, FieldMapper> newMappers = new HashMap<String, FieldMapper>();
            for (FieldMapper mapper : mergeWith.mappers.values()) {
                FieldMapper mergeIntoMapper = this.mappers.get(mapper.simpleName());
                if (mergeIntoMapper == null) {
                    newMappers.put(mapper.simpleName(), mapper);
                    continue;
                }
                FieldMapper merged = mergeIntoMapper.merge(mapper);
                newMappers.put(merged.simpleName(), merged);
            }
            return new MultiFields(Collections.unmodifiableMap(newMappers));
        }

        @Override
        public Iterator<FieldMapper> iterator() {
            return this.mappers.values().iterator();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (!this.mappers.isEmpty()) {
                ArrayList<FieldMapper> sortedMappers = new ArrayList<FieldMapper>(this.mappers.values());
                sortedMappers.sort(Comparator.comparing(FieldMapper::name));
                builder.startObject("fields");
                for (Mapper mapper : sortedMappers) {
                    mapper.toXContent(builder, params);
                }
                builder.endObject();
            }
            return builder;
        }

        public static class Builder {
            private final Map<String, Function<ContentPath, FieldMapper>> mapperBuilders = new HashMap<String, Function<ContentPath, FieldMapper>>();

            public Builder add(org.elasticsearch.index.mapper.FieldMapper$Builder builder) {
                this.mapperBuilders.put(builder.name(), builder::build);
                return this;
            }

            public Builder add(FieldMapper mapper) {
                this.mapperBuilders.put(mapper.simpleName(), context -> mapper);
                return this;
            }

            public Builder update(FieldMapper toMerge, ContentPath contentPath) {
                if (!this.mapperBuilders.containsKey(toMerge.simpleName())) {
                    this.add(toMerge);
                } else {
                    FieldMapper existing = this.mapperBuilders.get(toMerge.simpleName()).apply(contentPath);
                    this.add(existing.merge(toMerge));
                }
                return this;
            }

            public MultiFields build(Mapper.Builder mainFieldBuilder, ContentPath contentPath) {
                if (this.mapperBuilders.isEmpty()) {
                    return MultiFields.empty();
                }
                HashMap<String, FieldMapper> mappers = new HashMap<String, FieldMapper>();
                contentPath.add(mainFieldBuilder.name());
                for (Map.Entry<String, Function<ContentPath, FieldMapper>> entry : this.mapperBuilders.entrySet()) {
                    String key = entry.getKey();
                    FieldMapper mapper = entry.getValue().apply(contentPath);
                    mappers.put(key, mapper);
                }
                contentPath.remove();
                return new MultiFields(Collections.unmodifiableMap(mappers));
            }
        }
    }

    public static class CopyTo {
        private static final CopyTo EMPTY = new CopyTo(Collections.emptyList());
        private final List<String> copyToFields;

        public static CopyTo empty() {
            return EMPTY;
        }

        private CopyTo(List<String> copyToFields) {
            this.copyToFields = copyToFields;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (!this.copyToFields.isEmpty()) {
                builder.startArray("copy_to");
                for (String field : this.copyToFields) {
                    builder.value(field);
                }
                builder.endArray();
            }
            return builder;
        }

        public List<String> copyToFields() {
            return this.copyToFields;
        }

        public static class Builder {
            private final List<String> copyToBuilders = new ArrayList<String>();

            public Builder add(String field) {
                this.copyToBuilders.add(field);
                return this;
            }

            public CopyTo build() {
                if (this.copyToBuilders.isEmpty()) {
                    return EMPTY;
                }
                return new CopyTo(Collections.unmodifiableList(this.copyToBuilders));
            }

            public void reset(CopyTo copyTo) {
                this.copyToBuilders.clear();
                this.copyToBuilders.addAll(copyTo.copyToFields);
            }
        }
    }

    public static abstract class Builder
    extends Mapper.Builder {
        protected final MultiFields.Builder multiFieldsBuilder = new MultiFields.Builder();
        protected final CopyTo.Builder copyTo = new CopyTo.Builder();
        private static final Set<String> DEPRECATED_PARAMS = new HashSet<String>(Arrays.asList("store", "meta", "index", "doc_values", "index_options", "similarity", "boost"));

        protected Builder(String name) {
            super(name);
        }

        public Builder init(FieldMapper initializer) {
            for (Parameter<?> param : this.getParameters()) {
                ((Parameter)param).init(initializer);
            }
            for (FieldMapper subField : initializer.multiFields) {
                this.multiFieldsBuilder.add(subField);
            }
            return this;
        }

        private void merge(FieldMapper in, Conflicts conflicts) {
            for (Parameter<?> param : this.getParameters()) {
                ((Parameter)param).merge(in, conflicts);
            }
            for (FieldMapper newSubField : in.multiFields) {
                this.multiFieldsBuilder.update(newSubField, Builder.parentPath(newSubField.name()));
            }
            this.copyTo.reset(in.copyTo);
            this.validate();
        }

        private void validate() {
            for (Parameter<?> param : this.getParameters()) {
                ((Parameter)param).validate();
            }
        }

        protected abstract List<Parameter<?>> getParameters();

        @Override
        public abstract FieldMapper build(ContentPath var1);

        protected String buildFullName(ContentPath contentPath) {
            return contentPath.pathAsText(this.name);
        }

        public final void toXContent(XContentBuilder builder, boolean includeDefaults) throws IOException {
            for (Parameter<?> parameter : this.getParameters()) {
                parameter.toXContent(builder, includeDefaults);
            }
        }

        public final void parse(String name, Mapper.TypeParser.ParserContext parserContext, Map<String, Object> fieldNode) {
            HashMap paramsMap = new HashMap();
            HashMap deprecatedParamsMap = new HashMap();
            for (Parameter<?> param : this.getParameters()) {
                paramsMap.put(param.name, param);
                for (String deprecatedName : ((Parameter)param).deprecatedNames) {
                    deprecatedParamsMap.put(deprecatedName, param);
                }
            }
            String type = (String)fieldNode.remove("type");
            Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (Objects.equals("fields", propName)) {
                    TypeParsers.parseMultiField(this.multiFieldsBuilder::add, name, parserContext, propName, propNode);
                    iterator.remove();
                    continue;
                }
                if (Objects.equals("copy_to", propName)) {
                    TypeParsers.parseCopyFields(propNode).forEach(this.copyTo::add);
                    iterator.remove();
                    continue;
                }
                Parameter parameter = (Parameter)deprecatedParamsMap.get(propName);
                if (parameter != null) {
                    deprecationLogger.deprecate(DeprecationCategory.MAPPINGS, propName, "Parameter [{}] on mapper [{}] is deprecated, use [{}]", propName, name, parameter.name);
                } else {
                    parameter = (Parameter)paramsMap.get(propName);
                }
                if (parameter == null) {
                    if (Builder.isDeprecatedParameter(propName, parserContext.indexVersionCreated())) {
                        deprecationLogger.deprecate(DeprecationCategory.MAPPINGS, propName, "Parameter [{}] has no effect on type [{}] and will be removed in future", propName, type);
                        iterator.remove();
                        continue;
                    }
                    if (parserContext.isFromDynamicTemplate()) {
                        deprecationLogger.deprecate(DeprecationCategory.TEMPLATES, propName, "Parameter [{}] is used in a dynamic template mapping and has no effect on type [{}]. Usage will result in an error in future major versions and should be removed.", propName, type);
                        iterator.remove();
                        continue;
                    }
                    throw new MapperParsingException("unknown parameter [" + propName + "] on mapper [" + name + "] of type [" + type + "]");
                }
                if (Objects.equals("boost", propName)) {
                    deprecationLogger.deprecate(DeprecationCategory.MAPPINGS, "boost", "Parameter [boost] on field [{}] is deprecated and will be removed in 8.0", name);
                }
                if (parameter.deprecated) {
                    deprecationLogger.deprecate(DeprecationCategory.MAPPINGS, propName, "Parameter [{}] is deprecated and will be removed in a future version", propName);
                }
                if (propNode == null && !parameter.acceptsNull) {
                    throw new MapperParsingException("[" + propName + "] on mapper [" + name + "] of type [" + type + "] must not have a [null] value");
                }
                parameter.parse(name, parserContext, propNode);
                iterator.remove();
            }
            this.validate();
        }

        protected static ContentPath parentPath(String name) {
            int endPos = name.lastIndexOf(".");
            if (endPos == -1) {
                return new ContentPath(0);
            }
            return new ContentPath(name.substring(0, endPos));
        }

        private static boolean isDeprecatedParameter(String propName, Version indexCreatedVersion) {
            return DEPRECATED_PARAMS.contains(propName);
        }
    }

    public static final class Conflicts {
        private final String mapperName;
        private final List<String> conflicts = new ArrayList<String>();

        Conflicts(String mapperName) {
            this.mapperName = mapperName;
        }

        public void addConflict(String parameter, String conflict) {
            this.conflicts.add("Conflict in parameter [" + parameter + "]: " + conflict);
        }

        void addConflict(String parameter, String existing, String toMerge) {
            this.conflicts.add("Cannot update parameter [" + parameter + "] from [" + existing + "] to [" + toMerge + "]");
        }

        void check() {
            if (this.conflicts.isEmpty()) {
                return;
            }
            String message = "Mapper for [" + this.mapperName + "] conflicts with existing mapper:\n\t" + String.join((CharSequence)"\n\t", this.conflicts);
            throw new IllegalArgumentException(message);
        }
    }

    public static final class TypeParser
    implements Mapper.TypeParser {
        private final BiFunction<String, Mapper.TypeParser.ParserContext, Builder> builderFunction;

        public TypeParser(BiFunction<String, Mapper.TypeParser.ParserContext, Builder> builderFunction) {
            this.builderFunction = builderFunction;
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = this.builderFunction.apply(name, parserContext);
            builder.parse(name, parserContext, node);
            return builder;
        }
    }

    public static final class Parameter<T>
    implements Supplier<T> {
        public final String name;
        private final List<String> deprecatedNames = new ArrayList<String>();
        private final Supplier<T> defaultValue;
        private final TriFunction<String, Mapper.TypeParser.ParserContext, Object, T> parser;
        private final Function<FieldMapper, T> initializer;
        private boolean acceptsNull = false;
        private Consumer<T> validator = null;
        private Serializer<T> serializer = XContentBuilder::field;
        private SerializerCheck<T> serializerCheck = (includeDefaults, isConfigured, value) -> includeDefaults || isConfigured;
        private Function<T, String> conflictSerializer = Objects::toString;
        private boolean deprecated;
        private MergeValidator<T> mergeValidator;
        private T value;
        private boolean isSet;

        public Parameter(String name, boolean updateable, Supplier<T> defaultValue, TriFunction<String, Mapper.TypeParser.ParserContext, Object, T> parser, Function<FieldMapper, T> initializer) {
            this.name = name;
            this.defaultValue = Objects.requireNonNull(defaultValue);
            this.value = null;
            this.parser = parser;
            this.initializer = initializer;
            this.mergeValidator = (previous, toMerge, conflicts) -> updateable || Objects.equals(previous, toMerge);
        }

        public T getValue() {
            return this.isSet ? this.value : this.defaultValue.get();
        }

        @Override
        public T get() {
            return this.getValue();
        }

        public T getDefaultValue() {
            return this.defaultValue.get();
        }

        public void setValue(T value) {
            this.isSet = true;
            this.value = value;
        }

        public boolean isConfigured() {
            return this.isSet && !Objects.equals(this.value, this.defaultValue.get());
        }

        public Parameter<T> acceptsNull() {
            this.acceptsNull = true;
            return this;
        }

        public Parameter<T> addDeprecatedName(String deprecatedName) {
            this.deprecatedNames.add(deprecatedName);
            return this;
        }

        public Parameter<T> deprecated() {
            this.deprecated = true;
            return this;
        }

        public Parameter<T> setValidator(Consumer<T> validator) {
            this.validator = validator;
            return this;
        }

        public Parameter<T> setSerializer(Serializer<T> serializer, Function<T, String> conflictSerializer) {
            this.serializer = serializer;
            this.conflictSerializer = conflictSerializer;
            return this;
        }

        public Parameter<T> setSerializerCheck(SerializerCheck<T> check) {
            this.serializerCheck = check;
            return this;
        }

        public Parameter<T> alwaysSerialize() {
            this.serializerCheck = (id, ic, v) -> true;
            return this;
        }

        public Parameter<T> neverSerialize() {
            this.serializerCheck = (id, ic, v) -> false;
            return this;
        }

        public Parameter<T> setMergeValidator(MergeValidator<T> mergeValidator) {
            this.mergeValidator = mergeValidator;
            return this;
        }

        private void validate() {
            if (this.validator != null) {
                this.validator.accept(this.getValue());
            }
        }

        private void init(FieldMapper toInit) {
            this.setValue(this.initializer.apply(toInit));
        }

        private void parse(String field, Mapper.TypeParser.ParserContext context, Object in) {
            this.setValue(this.parser.apply(field, context, in));
        }

        private void merge(FieldMapper toMerge, Conflicts conflicts) {
            T value = this.initializer.apply(toMerge);
            T current = this.getValue();
            if (this.mergeValidator.canMerge(current, value, conflicts)) {
                this.setValue(value);
            } else {
                conflicts.addConflict(this.name, this.conflictSerializer.apply(current), this.conflictSerializer.apply(value));
            }
        }

        protected void toXContent(XContentBuilder builder, boolean includeDefaults) throws IOException {
            if (this.serializerCheck.check(includeDefaults, this.isConfigured(), this.get())) {
                this.serializer.serialize(builder, this.name, this.getValue());
            }
        }

        public static Parameter<Boolean> boolParam(String name, boolean updateable, Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return new Parameter<Boolean>(name, updateable, () -> defaultValue, (n, c, o) -> XContentMapValues.nodeBooleanValue(o), initializer);
        }

        public static Parameter<Explicit<Boolean>> explicitBoolParam(String name, boolean updateable, Function<FieldMapper, Explicit<Boolean>> initializer, boolean defaultValue) {
            Explicit<Boolean> defaultExplicit = new Explicit<Boolean>(defaultValue, false);
            return new Parameter<Explicit<Boolean>>(name, updateable, () -> defaultExplicit, (n, c, o) -> new Explicit<Boolean>(XContentMapValues.nodeBooleanValue(o), true), initializer).setSerializer((b, n, v) -> b.field(n, (Boolean)v.value()), v -> Boolean.toString((Boolean)v.value()));
        }

        public static Parameter<Double> doubleParam(String name, boolean updateable, Function<FieldMapper, Double> initializer, double defaultValue) {
            return new Parameter<Double>(name, updateable, () -> defaultValue, (n, c, o) -> XContentMapValues.nodeDoubleValue(o), initializer);
        }

        public static Parameter<Float> floatParam(String name, boolean updateable, Function<FieldMapper, Float> initializer, float defaultValue) {
            return new Parameter<Float>(name, updateable, () -> Float.valueOf(defaultValue), (n, c, o) -> Float.valueOf(XContentMapValues.nodeFloatValue(o)), initializer);
        }

        public static Parameter<Integer> intParam(String name, boolean updateable, Function<FieldMapper, Integer> initializer, int defaultValue) {
            return new Parameter<Integer>(name, updateable, () -> defaultValue, (n, c, o) -> XContentMapValues.nodeIntegerValue(o), initializer);
        }

        public static Parameter<String> stringParam(String name, boolean updateable, Function<FieldMapper, String> initializer, String defaultValue) {
            return new Parameter<String>(name, updateable, () -> defaultValue, (n, c, o) -> XContentMapValues.nodeStringValue(o), initializer);
        }

        public static Parameter<List<String>> stringArrayParam(String name, boolean updateable, Function<FieldMapper, List<String>> initializer, List<String> defaultValue) {
            return new Parameter<List<String>>(name, updateable, () -> defaultValue, (n, c, o) -> {
                List values = (List)o;
                ArrayList<String> strValues = new ArrayList<String>();
                for (Object item : values) {
                    strValues.add(item.toString());
                }
                return strValues;
            }, initializer);
        }

        public static Parameter<String> restrictedStringParam(String name, boolean updateable, Function<FieldMapper, String> initializer, String ... values) {
            assert (values.length > 0);
            LinkedHashSet<String> acceptedValues = new LinkedHashSet<String>(Arrays.asList(values));
            return Parameter.stringParam(name, updateable, initializer, values[0]).setValidator(v -> {
                if (acceptedValues.contains(v)) {
                    return;
                }
                throw new MapperParsingException("Unknown value [" + v + "] for field [" + name + "] - accepted values are " + acceptedValues.toString());
            });
        }

        public static Parameter<NamedAnalyzer> analyzerParam(String name, boolean updateable, Function<FieldMapper, NamedAnalyzer> initializer, Supplier<NamedAnalyzer> defaultAnalyzer) {
            return new Parameter<NamedAnalyzer>(name, updateable, defaultAnalyzer, (n, c, o) -> {
                String analyzerName = o.toString();
                NamedAnalyzer a = c.getIndexAnalyzers().get(analyzerName);
                if (a == null) {
                    throw new IllegalArgumentException("analyzer [" + analyzerName + "] has not been configured in mappings");
                }
                return a;
            }, initializer).setSerializer((b, n, v) -> b.field(n, v.name()), NamedAnalyzer::name);
        }

        public static Parameter<Map<String, String>> metaParam() {
            return new Parameter<Map<String, String>>("meta", true, Collections::emptyMap, (n, c, o) -> TypeParsers.parseMeta(n, o), m -> m.fieldType().meta());
        }

        public static Parameter<Float> boostParam() {
            return Parameter.floatParam("boost", true, m -> Float.valueOf(m.fieldType().boost()), 1.0f);
        }

        public static Parameter<Boolean> indexParam(Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return Parameter.boolParam("index", false, initializer, defaultValue);
        }

        public static Parameter<Boolean> storeParam(Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return Parameter.boolParam("store", false, initializer, defaultValue);
        }

        public static Parameter<Boolean> docValuesParam(Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return Parameter.boolParam("doc_values", false, initializer, defaultValue);
        }
    }

    public static interface SerializerCheck<T> {
        public boolean check(boolean var1, boolean var2, T var3);
    }

    protected static interface MergeValidator<T> {
        public boolean canMerge(T var1, T var2, Conflicts var3);
    }

    public static interface Serializer<T> {
        public void serialize(XContentBuilder var1, String var2, T var3) throws IOException;
    }
}

