/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;

public final class MappingParser {
    private final Supplier<Mapper.TypeParser.ParserContext> parserContextSupplier;
    private final RootObjectMapper.TypeParser rootObjectTypeParser = new RootObjectMapper.TypeParser();
    private final Function<String, Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>> metadataMappersFunction;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers;
    private final Function<String, String> documentTypeResolver;
    private final NamedXContentRegistry xContentRegistry;

    MappingParser(Supplier<Mapper.TypeParser.ParserContext> parserContextSupplier, Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers, Function<String, Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>> metadataMappersFunction, Function<String, String> documentTypeResolver, NamedXContentRegistry xContentRegistry) {
        this.parserContextSupplier = parserContextSupplier;
        this.metadataMappersFunction = metadataMappersFunction;
        this.metadataMapperParsers = metadataMapperParsers;
        this.documentTypeResolver = documentTypeResolver;
        this.xContentRegistry = xContentRegistry;
    }

    public static void checkNoRemainingFields(String fieldName, Map<?, ?> fieldNodeMap) {
        MappingParser.checkNoRemainingFields(fieldNodeMap, "Mapping definition for [" + fieldName + "] has unsupported parameters: ");
    }

    public static void checkNoRemainingFields(Map<?, ?> fieldNodeMap, String message) {
        if (!fieldNodeMap.isEmpty()) {
            throw new MapperParsingException(message + MappingParser.getRemainingFields(fieldNodeMap));
        }
    }

    private static String getRemainingFields(Map<?, ?> map) {
        StringBuilder remainingFields = new StringBuilder();
        for (Object key : map.keySet()) {
            remainingFields.append(" [").append(key).append(" : ").append(map.get(key)).append("]");
        }
        return remainingFields.toString();
    }

    public Mapping parse(@Nullable String type, CompressedXContent source) throws MapperParsingException {
        return this.parse(type, source, null);
    }

    public Mapping parse(@Nullable String type, CompressedXContent source, String defaultSource) throws MapperParsingException {
        Tuple<String, Map<String, Object>> t;
        Map<String, Object> mapping = null;
        if (source != null) {
            Map<String, Object> root = XContentHelper.convertToMap(source.compressedReference(), true, XContentType.JSON).v2();
            Tuple<String, Map<String, Object>> t2 = this.extractMapping(type, root);
            type = t2.v1();
            mapping = t2.v2();
        }
        if (mapping == null) {
            mapping = new HashMap<String, Object>();
        }
        if (type == null) {
            throw new MapperParsingException("Failed to derive type");
        }
        if (defaultSource != null && (t = this.extractMapping("_default_", defaultSource)).v2() != null) {
            XContentHelper.mergeDefaults(mapping, t.v2());
        }
        ContentPath contentPath = new ContentPath(1);
        Mapper.TypeParser.ParserContext parserContext = this.parserContextSupplier.get();
        RootObjectMapper rootObjectMapper = ((RootObjectMapper.Builder)this.rootObjectTypeParser.parse(type, (Map)mapping, parserContext)).build(contentPath);
        Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = this.metadataMappersFunction.apply(type);
        Map<String, Object> meta = null;
        Iterator<Map.Entry<String, Object>> iterator = mapping.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String fieldName = entry.getKey();
            Object fieldNode = entry.getValue();
            MetadataFieldMapper.TypeParser typeParser = this.metadataMapperParsers.get(fieldName);
            if (typeParser == null) continue;
            iterator.remove();
            if (!(fieldNode instanceof Map)) {
                throw new IllegalArgumentException("[_parent] must be an object containing [type]");
            }
            Map fieldNodeMap = (Map)fieldNode;
            MetadataFieldMapper metadataFieldMapper = ((MetadataFieldMapper.Builder)typeParser.parse(fieldName, fieldNodeMap, parserContext)).build(contentPath);
            metadataMappers.put(metadataFieldMapper.getClass(), metadataFieldMapper);
            fieldNodeMap.remove("type");
            MappingParser.checkNoRemainingFields(fieldName, fieldNodeMap);
        }
        Map removed = (Map)mapping.remove("_meta");
        if (removed != null) {
            meta = Collections.unmodifiableMap(new HashMap(removed));
        }
        MappingParser.checkNoRemainingFields(mapping, "Root mapping definition has unsupported parameters: ");
        return new Mapping(rootObjectMapper, metadataMappers.values().toArray(new MetadataFieldMapper[0]), meta);
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, String source) throws MapperParsingException {
        Map<String, Object> root;
        try (XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, source);){
            root = parser.mapOrdered();
        }
        catch (Exception e) {
            throw new MapperParsingException("failed to parse mapping definition", e);
        }
        return this.extractMapping(type, root);
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, Map<String, Object> root) throws MapperParsingException {
        if (root.size() == 0) {
            if (type != null) {
                return new Tuple<String, Map<String, Object>>(type, root);
            }
            throw new MapperParsingException("malformed mapping, no type name found");
        }
        String rootName = root.keySet().iterator().next();
        Tuple<String, Map<String, Object>> mapping = type == null || type.equals(rootName) || this.documentTypeResolver.apply(type).equals(rootName) ? new Tuple<String, Map<String, Object>>(rootName, (Map)root.get(rootName)) : new Tuple<String, Map<String, Object>>(type, root);
        return mapping;
    }
}

