/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class SystemIndexDescriptor {
    private final String indexPattern;
    private final String primaryIndex;
    private final String description;
    private final CharacterRunAutomaton indexPatternAutomaton;
    private final String mappings;
    private final Settings settings;
    private final String aliasName;
    private final int indexFormat;
    private final String versionMetaKey;
    private final String origin;
    private final String indexType;
    private final Version minimumNodeVersion;

    public SystemIndexDescriptor(String indexPattern, String description) {
        this(indexPattern, null, description, null, null, null, 0, null, null, "_doc", null);
    }

    SystemIndexDescriptor(String indexPattern, String primaryIndex, String description, String mappings, Settings settings, String aliasName, int indexFormat, String versionMetaKey, String origin, String indexType, Version minimumNodeVersion) {
        Objects.requireNonNull(indexPattern, "system index pattern must not be null");
        if (indexPattern.length() < 2) {
            throw new IllegalArgumentException("system index pattern provided as [" + indexPattern + "] but must at least 2 characters in length");
        }
        if (indexPattern.charAt(0) != '.') {
            throw new IllegalArgumentException("system index pattern provided as [" + indexPattern + "] but must start with the character [.]");
        }
        if (indexPattern.charAt(1) == '*') {
            throw new IllegalArgumentException("system index pattern provided as [" + indexPattern + "] but must not start with the character sequence [.*] to prevent conflicts");
        }
        if (primaryIndex != null) {
            if (primaryIndex.charAt(0) != '.') {
                throw new IllegalArgumentException("system primary index provided as [" + primaryIndex + "] but must start with the character [.]");
            }
            if (!primaryIndex.matches("^\\.[\\w-]+$")) {
                throw new IllegalArgumentException("system primary index provided as [" + primaryIndex + "] but cannot contain special characters or patterns");
            }
            Strings.requireNonEmpty(indexType, "Index type cannot be null or empty if primaryIndex is supplied");
        }
        if (indexFormat < 0) {
            throw new IllegalArgumentException("Index format cannot be negative");
        }
        Strings.requireNonEmpty(indexPattern, "indexPattern must be supplied");
        if (mappings != null || settings != null) {
            Strings.requireNonEmpty(primaryIndex, "Must supply primaryIndex if mappings or settings are defined");
            Strings.requireNonEmpty(versionMetaKey, "Must supply versionMetaKey if mappings or settings are defined");
            Strings.requireNonEmpty(origin, "Must supply origin if mappings or settings are defined");
        }
        this.indexPattern = indexPattern;
        this.primaryIndex = primaryIndex;
        Automaton automaton = SystemIndexDescriptor.buildAutomaton(indexPattern, aliasName);
        this.indexPatternAutomaton = new CharacterRunAutomaton(automaton);
        this.description = description;
        this.mappings = mappings;
        this.settings = settings;
        this.aliasName = aliasName;
        this.indexFormat = indexFormat;
        this.versionMetaKey = versionMetaKey;
        this.origin = origin;
        this.indexType = indexType;
        this.minimumNodeVersion = minimumNodeVersion;
    }

    public String getIndexPattern() {
        return this.indexPattern;
    }

    public String getPrimaryIndex() {
        return this.primaryIndex;
    }

    public boolean matchesIndexPattern(String index) {
        return this.indexPatternAutomaton.run(index);
    }

    public List<String> getMatchingIndices(Metadata metadata) {
        ArrayList matchingIndices = new ArrayList();
        metadata.indices().keysIt().forEachRemaining(indexName -> {
            if (this.matchesIndexPattern((String)indexName)) {
                matchingIndices.add(indexName);
            }
        });
        return Collections.unmodifiableList(matchingIndices);
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "SystemIndexDescriptor[pattern=[" + this.indexPattern + "], description=[" + this.description + "], aliasName=[" + this.aliasName + "]]";
    }

    public String getMappings() {
        return this.mappings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public int getIndexFormat() {
        return this.indexFormat;
    }

    public String getVersionMetaKey() {
        return this.versionMetaKey;
    }

    public boolean isAutomaticallyManaged() {
        return this.mappings != null || this.settings != null;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public String checkMinimumNodeVersion(String cause, Version actualMinimumNodeVersion) {
        Objects.requireNonNull(cause);
        if (this.minimumNodeVersion != null && this.minimumNodeVersion.after(actualMinimumNodeVersion)) {
            return String.format(Locale.ROOT, "[%s] failed - system index [%s] requires all cluster nodes to be at least version [%s]", cause, this.getPrimaryIndex(), this.minimumNodeVersion);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    static Automaton buildAutomaton(String pattern, String alias) {
        String patternAsRegex = SystemIndexDescriptor.patternToRegex(pattern);
        String aliasAsRegex = alias == null ? null : SystemIndexDescriptor.patternToRegex(alias);
        Automaton patternAutomaton = new RegExp(patternAsRegex).toAutomaton();
        if (aliasAsRegex == null) {
            return patternAutomaton;
        }
        Automaton aliasAutomaton = new RegExp(aliasAsRegex).toAutomaton();
        return Operations.union(patternAutomaton, aliasAutomaton);
    }

    private static String patternToRegex(String input) {
        String output = input;
        output = output.replaceAll("\\.", "\\.");
        output = output.replaceAll("\\*", ".*");
        return output;
    }

    public static class Builder {
        private String indexPattern;
        private String primaryIndex;
        private String description;
        private String mappings = null;
        private Settings settings = null;
        private String aliasName = null;
        private int indexFormat = 0;
        private String versionMetaKey = null;
        private String origin = null;
        private String indexType = "_doc";
        private Version minimumNodeVersion = null;

        private Builder() {
        }

        public Builder setIndexPattern(String indexPattern) {
            this.indexPattern = indexPattern;
            return this;
        }

        public Builder setPrimaryIndex(String primaryIndex) {
            this.primaryIndex = primaryIndex;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setMappings(XContentBuilder mappingsBuilder) {
            this.mappings = mappingsBuilder == null ? null : Strings.toString(mappingsBuilder);
            return this;
        }

        public Builder setMappings(String mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder setSettings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder setAliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public Builder setIndexFormat(int indexFormat) {
            this.indexFormat = indexFormat;
            return this;
        }

        public Builder setVersionMetaKey(String versionMetaKey) {
            this.versionMetaKey = versionMetaKey;
            return this;
        }

        public Builder setOrigin(String origin) {
            this.origin = origin;
            return this;
        }

        @Deprecated
        public Builder setIndexType(String indexType) {
            this.indexType = indexType;
            return this;
        }

        public Builder setMinimumNodeVersion(Version version) {
            this.minimumNodeVersion = version;
            return this;
        }

        public SystemIndexDescriptor build() {
            return new SystemIndexDescriptor(this.indexPattern, this.primaryIndex, this.description, this.mappings, this.settings, this.aliasName, this.indexFormat, this.versionMetaKey, this.origin, this.indexType, this.minimumNodeVersion);
        }
    }
}

