/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;

public class BestBucketsDeferringCollector
extends DeferringBucketCollector {
    private final Query topLevelQuery;
    private final IndexSearcher searcher;
    private final boolean isGlobal;
    private List<Entry> entries = new ArrayList<Entry>();
    private BucketCollector collector;
    private LeafReaderContext context;
    private PackedLongValues.Builder docDeltasBuilder;
    private PackedLongValues.Builder bucketsBuilder;
    private LongHash selectedBuckets;
    private boolean finished = false;

    public BestBucketsDeferringCollector(Query topLevelQuery, IndexSearcher searcher, boolean isGlobal) {
        this.topLevelQuery = topLevelQuery;
        this.searcher = searcher;
        this.isGlobal = isGlobal;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.collector == null) {
            throw new IllegalStateException();
        }
        return this.collector.scoreMode();
    }

    @Override
    public void setDeferredCollector(Iterable<BucketCollector> deferredCollectors) {
        this.collector = MultiBucketCollector.wrap(deferredCollectors);
    }

    private void finishLeaf() {
        if (this.context != null) {
            assert (this.docDeltasBuilder != null && this.bucketsBuilder != null);
            assert (this.docDeltasBuilder.size() > 0L);
            this.entries.add(new Entry(this.context, this.docDeltasBuilder.build(), this.bucketsBuilder.build()));
            this.clearLeaf();
        }
    }

    private void clearLeaf() {
        this.context = null;
        this.docDeltasBuilder = null;
        this.bucketsBuilder = null;
    }

    @Override
    public LeafBucketCollector getLeafCollector(final LeafReaderContext ctx) throws IOException {
        this.finishLeaf();
        return new LeafBucketCollector(){
            int lastDoc = 0;

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (BestBucketsDeferringCollector.this.context == null) {
                    BestBucketsDeferringCollector.this.context = ctx;
                    BestBucketsDeferringCollector.this.docDeltasBuilder = PackedLongValues.packedBuilder(0.25f);
                    BestBucketsDeferringCollector.this.bucketsBuilder = PackedLongValues.packedBuilder(0.25f);
                }
                BestBucketsDeferringCollector.this.docDeltasBuilder.add(doc - this.lastDoc);
                BestBucketsDeferringCollector.this.bucketsBuilder.add(bucket);
                this.lastDoc = doc;
            }
        };
    }

    @Override
    public void preCollection() throws IOException {
        this.collector.preCollection();
    }

    @Override
    public void postCollection() throws IOException {
        this.finishLeaf();
        this.finished = true;
    }

    @Override
    public void prepareSelectedBuckets(long ... selectedBuckets) throws IOException {
        if (!this.finished) {
            throw new IllegalStateException("Cannot replay yet, collection is not finished: postCollect() has not been called");
        }
        if (this.selectedBuckets != null) {
            throw new IllegalStateException("Already been replayed");
        }
        this.selectedBuckets = new LongHash(selectedBuckets.length, BigArrays.NON_RECYCLING_INSTANCE);
        for (long ord : selectedBuckets) {
            this.selectedBuckets.add(ord);
        }
        boolean needsScores = this.scoreMode().needsScores();
        Weight weight = null;
        if (needsScores) {
            Query query = this.isGlobal ? new MatchAllDocsQuery() : this.topLevelQuery;
            weight = this.searcher.createWeight(this.searcher.rewrite(query), ScoreMode.COMPLETE, 1.0f);
        }
        for (Entry entry : this.entries) {
            assert (entry.docDeltas.size() > 0L) : "segment should have at least one document to replay, got 0";
            try {
                LeafBucketCollector leafCollector = this.collector.getLeafCollector(entry.context);
                DocIdSetIterator scoreIt = null;
                if (needsScores) {
                    Scorer scorer = weight.scorer(entry.context);
                    scoreIt = scorer.iterator();
                    leafCollector.setScorer(scorer);
                }
                PackedLongValues.Iterator docDeltaIterator = entry.docDeltas.iterator();
                PackedLongValues.Iterator buckets = entry.buckets.iterator();
                int doc = 0;
                long end = entry.docDeltas.size();
                for (long i = 0L; i < end; ++i) {
                    doc = (int)((long)doc + docDeltaIterator.next());
                    long bucket = buckets.next();
                    long rebasedBucket = this.selectedBuckets.find(bucket);
                    if (rebasedBucket == -1L) continue;
                    if (needsScores) {
                        if (scoreIt.docID() < doc) {
                            scoreIt.advance(doc);
                        }
                        assert (scoreIt.docID() == doc);
                    }
                    leafCollector.collect(doc, rebasedBucket);
                }
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
            }
        }
        this.collector.postCollection();
    }

    @Override
    public Aggregator wrap(final Aggregator in) {
        return new DeferringBucketCollector.WrappedAggregator(in){

            @Override
            public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
                if (BestBucketsDeferringCollector.this.selectedBuckets == null) {
                    throw new IllegalStateException("Collection has not been replayed yet.");
                }
                long[] rebasedOrds = new long[owningBucketOrds.length];
                for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                    rebasedOrds[ordIdx] = BestBucketsDeferringCollector.this.selectedBuckets.find(owningBucketOrds[ordIdx]);
                    if (rebasedOrds[ordIdx] != -1L) continue;
                    throw new IllegalStateException("Cannot build for a bucket which has not been collected");
                }
                return in.buildAggregations(rebasedOrds);
            }
        };
    }

    public void rewriteBuckets(LongUnaryOperator howToRewrite) {
        long ordinal;
        long delta;
        long bucket;
        PackedLongValues.Iterator itr;
        long lastGoodDelta;
        PackedLongValues.Iterator docDeltasItr;
        ArrayList<Entry> newEntries = new ArrayList<Entry>(this.entries.size());
        for (Entry sourceEntry : this.entries) {
            PackedLongValues.Builder newBuckets = PackedLongValues.packedBuilder(0.25f);
            PackedLongValues.Builder newDocDeltas = PackedLongValues.packedBuilder(0.25f);
            docDeltasItr = sourceEntry.docDeltas.iterator();
            lastGoodDelta = 0L;
            itr = sourceEntry.buckets.iterator();
            while (itr.hasNext()) {
                bucket = itr.next();
                assert (docDeltasItr.hasNext());
                delta = docDeltasItr.next();
                ordinal = howToRewrite.applyAsLong(bucket);
                if (ordinal != -1L) {
                    newBuckets.add(ordinal);
                    newDocDeltas.add(delta + lastGoodDelta);
                    lastGoodDelta = 0L;
                    continue;
                }
                lastGoodDelta += delta;
            }
            if (newBuckets.size() <= 0L) continue;
            assert (newDocDeltas.size() > 0L) : "docDeltas was empty but we had buckets";
            newEntries.add(new Entry(sourceEntry.context, newDocDeltas.build(), newBuckets.build()));
        }
        this.entries = newEntries;
        if (this.bucketsBuilder != null && this.bucketsBuilder.size() > 0L) {
            PackedLongValues currentBuckets = this.bucketsBuilder.build();
            PackedLongValues.Builder newBuckets = PackedLongValues.packedBuilder(0.25f);
            PackedLongValues.Builder newDocDeltas = PackedLongValues.packedBuilder(0.25f);
            PackedLongValues currentDeltas = this.docDeltasBuilder.build();
            docDeltasItr = currentDeltas.iterator();
            lastGoodDelta = 0L;
            itr = currentBuckets.iterator();
            while (itr.hasNext()) {
                bucket = itr.next();
                assert (docDeltasItr.hasNext());
                delta = docDeltasItr.next();
                ordinal = howToRewrite.applyAsLong(bucket);
                if (ordinal != -1L) {
                    newBuckets.add(ordinal);
                    newDocDeltas.add(delta + lastGoodDelta);
                    lastGoodDelta = 0L;
                    continue;
                }
                lastGoodDelta += delta;
            }
            if (newDocDeltas.size() == 0L) {
                this.clearLeaf();
            } else {
                this.docDeltasBuilder = newDocDeltas;
                this.bucketsBuilder = newBuckets;
            }
        }
    }

    static class Entry {
        final LeafReaderContext context;
        final PackedLongValues docDeltas;
        final PackedLongValues buckets;

        Entry(LeafReaderContext context, PackedLongValues docDeltas, PackedLongValues buckets) {
            this.context = Objects.requireNonNull(context);
            this.docDeltas = Objects.requireNonNull(docDeltas);
            this.buckets = Objects.requireNonNull(buckets);
        }
    }
}

