/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class SourceCode {
    public static final String EOL = System.getProperty("line.separator", "\n");
    private CodeLoader cl;

    public SourceCode(CodeLoader cl) {
        this.cl = cl;
    }

    public List<String> getCode() {
        return this.cl.getCode();
    }

    public StringBuffer getCodeBuffer() {
        StringBuffer sb = new StringBuffer();
        List<String> lines = this.cl.getCode();
        for (String line : lines) {
            sb.append(line);
            sb.append(EOL);
        }
        return sb;
    }

    public String getSlice(int startLine, int endLine) {
        int i;
        StringBuffer sb = new StringBuffer();
        List<String> lines = this.cl.getCode();
        int n = i = startLine == 0 ? startLine : startLine - 1;
        while (i < endLine && i < lines.size()) {
            if (sb.length() != 0) {
                sb.append(EOL);
            }
            sb.append(lines.get(i));
            ++i;
        }
        return sb.toString();
    }

    public String getFileName() {
        return this.cl.getFileName();
    }

    public static class StringCodeLoader
    extends CodeLoader {
        public static final String DEFAULT_NAME = "CODE_LOADED_FROM_STRING";
        private String sourceCode;
        private String name;

        public StringCodeLoader(String code) {
            this(code, DEFAULT_NAME);
        }

        public StringCodeLoader(String code, String name) {
            this.sourceCode = code;
            this.name = name;
        }

        @Override
        public Reader getReader() {
            return new StringReader(this.sourceCode);
        }

        @Override
        public String getFileName() {
            return this.name;
        }
    }

    public static class FileCodeLoader
    extends CodeLoader {
        private File file;
        private String encoding;

        public FileCodeLoader(File file, String encoding) {
            this.file = file;
            this.encoding = encoding;
        }

        @Override
        public Reader getReader() throws Exception {
            return new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding);
        }

        @Override
        public String getFileName() {
            return this.file.getAbsolutePath();
        }
    }

    public static abstract class CodeLoader {
        private SoftReference<List<String>> code;

        public List<String> getCode() {
            List<String> c = null;
            if (this.code != null) {
                c = this.code.get();
            }
            if (c != null) {
                return c;
            }
            this.code = new SoftReference<List<String>>(this.load());
            return this.code.get();
        }

        public abstract String getFileName();

        protected abstract Reader getReader() throws Exception;

        protected List<String> load() {
            ArrayList<String> arrayList;
            LineNumberReader lnr = new LineNumberReader(this.getReader());
            try {
                String currentLine;
                ArrayList<String> lines = new ArrayList<String>();
                while ((currentLine = lnr.readLine()) != null) {
                    lines.add(currentLine);
                }
                arrayList = lines;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        lnr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Problem while reading " + this.getFileName() + ":" + e.getMessage(), e);
                }
            }
            lnr.close();
            return arrayList;
        }
    }
}

