/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;

public class DefaultSensorDescriptor
implements SensorDescriptor {
    private String name;
    private String[] languages = new String[0];
    private InputFile.Type type = null;
    private String[] ruleRepositories = new String[0];
    private boolean global = false;
    private Predicate<Configuration> configurationPredicate;

    public String name() {
        return this.name;
    }

    public Collection<String> languages() {
        return Arrays.asList(this.languages);
    }

    @Nullable
    public InputFile.Type type() {
        return this.type;
    }

    public Collection<String> ruleRepositories() {
        return Arrays.asList(this.ruleRepositories);
    }

    public Predicate<Configuration> configurationPredicate() {
        return this.configurationPredicate;
    }

    public boolean isGlobal() {
        return this.global;
    }

    @Override
    public DefaultSensorDescriptor name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public DefaultSensorDescriptor onlyOnLanguage(String languageKey) {
        return this.onlyOnLanguages(languageKey);
    }

    @Override
    public DefaultSensorDescriptor onlyOnLanguages(String ... languageKeys) {
        this.languages = languageKeys;
        return this;
    }

    @Override
    public DefaultSensorDescriptor onlyOnFileType(InputFile.Type type) {
        this.type = type;
        return this;
    }

    @Override
    public DefaultSensorDescriptor createIssuesForRuleRepository(String ... repositoryKey) {
        return this.createIssuesForRuleRepositories(repositoryKey);
    }

    @Override
    public DefaultSensorDescriptor createIssuesForRuleRepositories(String ... repositoryKeys) {
        this.ruleRepositories = repositoryKeys;
        return this;
    }

    @Override
    public DefaultSensorDescriptor requireProperty(String ... propertyKey) {
        return this.requireProperties(propertyKey);
    }

    @Override
    public DefaultSensorDescriptor requireProperties(String ... propertyKeys) {
        this.configurationPredicate = config -> Arrays.stream(propertyKeys).allMatch(config::hasKey);
        return this;
    }

    @Override
    public SensorDescriptor global() {
        this.global = true;
        return this;
    }

    @Override
    public SensorDescriptor onlyWhenConfiguration(Predicate<Configuration> configurationPredicate) {
        this.configurationPredicate = configurationPredicate;
        return this;
    }
}

