/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.PropertyType;
import org.sonar.api.config.EmailSettings;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.core.config.DebtProperties;
import org.sonar.core.config.ExclusionProperties;
import org.sonar.core.config.IssueExclusionProperties;
import org.sonar.core.config.PurgeProperties;
import org.sonar.core.config.ScannerProperties;
import org.sonar.core.config.SecurityProperties;
import org.sonar.core.config.SvnProperties;
import org.sonar.core.extension.PluginRiskConsent;

public class CorePropertyDefinitions {
    public static final String SONAR_ANALYSIS = "sonar.analysis.";
    public static final String SONAR_ANALYSIS_DETECTEDSCM = "sonar.analysis.detectedscm";
    public static final String SONAR_ANALYSIS_DETECTEDCI = "sonar.analysis.detectedci";
    public static final String DISABLE_NOTIFICATION_ON_BUILT_IN_QPROFILES = "sonar.builtInQualityProfiles.disableNotificationOnUpdate";
    public static final String PLUGINS_RISK_CONSENT = "sonar.plugins.risk.consent";

    private CorePropertyDefinitions() {
    }

    public static List<PropertyDefinition> all() {
        ArrayList<PropertyDefinition> defs = new ArrayList<PropertyDefinition>();
        defs.addAll(IssueExclusionProperties.all());
        defs.addAll(ExclusionProperties.all());
        defs.addAll(SecurityProperties.all());
        defs.addAll(DebtProperties.all());
        defs.addAll(PurgeProperties.all());
        defs.addAll(EmailSettings.definitions());
        defs.addAll(ScannerProperties.all());
        defs.addAll(SvnProperties.all());
        defs.addAll(Arrays.asList(PropertyDefinition.builder("sonar.subproject.settings.archived").name("Archived Sub-Projects Settings").description("DEPRECATED - List of the properties that were previously configured at sub-project / module level. These properties are not used anymore and should now be configured at project level. When you've made the necessary changes, clear this setting to prevent analysis from showing a warning about it.").category("general").subCategory("subProjects").onlyOnQualifiers("TRK", new String[0]).type(PropertyType.TEXT).build(), PropertyDefinition.builder("sonar.core.serverBaseURL").name("Server base URL").description("HTTP(S) URL of this SonarQube server, such as <i>https://yourhost.yourdomain/sonar</i>. This value is used i.e. to create links in emails.").category("general").build(), PropertyDefinition.builder("sonar.secretKeyPath").name("Encryption secret key path").description("Path to a file that contains encryption secret key that is used to encrypting other settings.").type(PropertyType.STRING).hidden().build(), PropertyDefinition.builder("sonar.authenticator.downcase").name("Downcase login").description("Downcase login during user authentication, typically for Active Directory").type(PropertyType.BOOLEAN).defaultValue(String.valueOf(false)).hidden().build(), PropertyDefinition.builder(DISABLE_NOTIFICATION_ON_BUILT_IN_QPROFILES).name("Avoid quality profiles notification").description("Avoid sending email notification on each update of built-in quality profiles to quality profile administrators.").defaultValue(Boolean.toString(false)).category("general").type(PropertyType.BOOLEAN).build(), PropertyDefinition.builder(PLUGINS_RISK_CONSENT).name("State of user plugins risk consent").description("Determine whether user is required to accept plugins risk consent").defaultValue(PluginRiskConsent.NOT_ACCEPTED.name()).options(Arrays.stream(PluginRiskConsent.values()).map(Enum::name).collect(Collectors.toList())).hidden().type(PropertyType.SINGLE_SELECT_LIST).build(), PropertyDefinition.builder("sonar.lf.logoUrl").deprecatedKey("sonar.branding.image").name("Logo URL").description("URL to logo image. Any standard format is accepted.").category("general").subCategory("looknfeel").build(), PropertyDefinition.builder("sonar.lf.logoWidthPx").deprecatedKey("sonar.branding.image.width").name("Width of image in pixels").description("Width in pixels, given that the height of the the image is constrained to 30px.").category("general").subCategory("looknfeel").build(), PropertyDefinition.builder("sonar.lf.enableGravatar").name("Enable support of gravatars").description("Gravatars are profile pictures of users based on their email.").type(PropertyType.BOOLEAN).defaultValue(String.valueOf(false)).category("general").subCategory("looknfeel").build(), PropertyDefinition.builder("sonar.lf.gravatarServerUrl").name("Gravatar URL").description("Optional URL of custom Gravatar service. Accepted variables are {EMAIL_MD5} for MD5 hash of email and {SIZE} for the picture size in pixels.").defaultValue("https://secure.gravatar.com/avatar/{EMAIL_MD5}.jpg?s={SIZE}&d=identicon").category("general").subCategory("looknfeel").build(), PropertyDefinition.builder("sonar.lf.aboutText").name("About page text").description("Optional text that is displayed on the About page. Supports html.").category("general").subCategory("looknfeel").type(PropertyType.TEXT).build(), PropertyDefinition.builder("sonar.developerAggregatedInfo.disabled").name("Disable developer aggregated information").description("Don't show issue facets aggregating information per developer").category("general").subCategory("issues").onQualifiers("TRK", new String[0]).type(PropertyType.BOOLEAN).defaultValue(Boolean.toString(false)).build(), PropertyDefinition.builder("sonar.issues.defaultAssigneeLogin").name("Default Assignee").description("New issues will be assigned to this user each time it is not possible to determine the user who is the author of the issue.").category("general").subCategory("issues").onQualifiers("TRK", new String[0]).type(PropertyType.USER_LOGIN).build(), PropertyDefinition.builder("sonar.qualitygate.ignoreSmallChanges").name("Ignore duplication and coverage on small changes").description("Quality Gate conditions about duplications in new code and coverage on new code are ignored until the number of new lines is at least 20.").category("general").subCategory("qualityGate").onQualifiers("TRK", new String[0]).type(PropertyType.BOOLEAN).defaultValue(Boolean.toString(true)).build(), PropertyDefinition.builder("sonar.cpd.cross_project").defaultValue(Boolean.toString(false)).name("Cross project duplication detection").description("DEPRECATED - By default, SonarQube detects duplications at project level. This means that a block duplicated on two different projects won't be reported. Setting this parameter to \"true\" allows to detect duplicates across projects. Note that activating this property will significantly increase each SonarQube analysis time, and therefore badly impact the performances of report processing as more and more projects are getting involved in this cross project duplication mechanism.").onQualifiers("TRK", new String[0]).category("general").subCategory("duplications").type(PropertyType.BOOLEAN).build(), PropertyDefinition.builder("sonar.cpd.exclusions").defaultValue("").name("Duplication Exclusions").description("Patterns used to exclude some source files from the duplication detection mechanism. See below to know how to use wildcards to specify this property.").onQualifiers("TRK", "BRC").category("exclusions").subCategory("duplications").multiValues(true).build()));
        return defs;
    }
}

