/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.statement.matcher;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.duplications.statement.matcher.TokenMatcher;
import org.sonar.duplications.token.Token;
import org.sonar.duplications.token.TokenQueue;

public class UptoTokenMatcher
extends TokenMatcher {
    private final Set<String> uptoMatchTokens = new HashSet<String>();

    public UptoTokenMatcher(String[] uptoMatchTokens) {
        if (uptoMatchTokens == null) {
            throw new IllegalArgumentException();
        }
        if (uptoMatchTokens.length == 0) {
            throw new IllegalArgumentException();
        }
        this.uptoMatchTokens.addAll(Arrays.asList(uptoMatchTokens));
    }

    @Override
    public boolean matchToken(TokenQueue tokenQueue, List<Token> matchedTokenList) {
        do {
            Token token = tokenQueue.poll();
            matchedTokenList.add(token);
            if (!this.uptoMatchTokens.contains(token.getValue())) continue;
            return true;
        } while (tokenQueue.peek() != null);
        return false;
    }
}

