/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.picocontainer.Startable;
import org.sonar.api.Plugin;
import org.sonar.api.utils.Preconditions;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.platform.ExplodedPlugin;
import org.sonar.core.platform.PluginClassLoader;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginJarExploder;
import org.sonar.core.platform.PluginRepository;
import org.sonar.scanner.bootstrap.PluginInstaller;
import org.sonar.scanner.bootstrap.ScannerPlugin;

public class ScannerPluginRepository
implements PluginRepository,
Startable {
    private static final Logger LOG = Loggers.get(ScannerPluginRepository.class);
    private final PluginInstaller installer;
    private final PluginJarExploder pluginJarExploder;
    private final PluginClassLoader loader;
    private Map<String, Plugin> pluginInstancesByKeys;
    private Map<String, ScannerPlugin> pluginsByKeys;
    private Map<ClassLoader, String> keysByClassLoader;

    public ScannerPluginRepository(PluginInstaller installer, PluginJarExploder pluginJarExploder, PluginClassLoader loader) {
        this.installer = installer;
        this.pluginJarExploder = pluginJarExploder;
        this.loader = loader;
    }

    @Override
    public void start() {
        this.pluginsByKeys = new HashMap<String, ScannerPlugin>(this.installer.installRemotes());
        Map<String, ExplodedPlugin> explodedPLuginsByKey = this.pluginsByKeys.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.pluginJarExploder.explode(((ScannerPlugin)e.getValue()).getInfo())));
        this.pluginInstancesByKeys = new HashMap<String, Plugin>(this.loader.load(explodedPLuginsByKey));
        for (Object[] objectArray : this.installer.installLocals()) {
            String pluginKey = (String)objectArray[0];
            PluginInfo pluginInfo = new PluginInfo(pluginKey);
            this.pluginsByKeys.put(pluginKey, new ScannerPlugin(pluginInfo.getKey(), (Long)objectArray[2], pluginInfo));
            this.pluginInstancesByKeys.put(pluginKey, (Plugin)objectArray[1]);
        }
        this.keysByClassLoader = new HashMap<ClassLoader, String>();
        for (Map.Entry entry : this.pluginInstancesByKeys.entrySet()) {
            this.keysByClassLoader.put(((Plugin)entry.getValue()).getClass().getClassLoader(), (String)entry.getKey());
        }
        this.logPlugins();
    }

    @CheckForNull
    public String getPluginKey(ClassLoader cl) {
        return this.keysByClassLoader.get(cl);
    }

    private void logPlugins() {
        if (this.pluginsByKeys.isEmpty()) {
            LOG.debug("No plugins loaded");
        } else {
            LOG.debug("Plugins:");
            for (ScannerPlugin p : this.pluginsByKeys.values()) {
                LOG.debug("  * {} {} ({})", p.getName(), p.getVersion(), p.getKey());
            }
        }
    }

    @Override
    public void stop() {
        this.loader.unload(this.pluginInstancesByKeys.values());
        this.pluginInstancesByKeys.clear();
        this.pluginsByKeys.clear();
        this.keysByClassLoader.clear();
    }

    public Map<String, ScannerPlugin> getPluginsByKey() {
        return this.pluginsByKeys;
    }

    @Override
    public Collection<PluginInfo> getPluginInfos() {
        return this.pluginsByKeys.values().stream().map(ScannerPlugin::getInfo).collect(Collectors.toList());
    }

    @Override
    public PluginInfo getPluginInfo(String key) {
        ScannerPlugin info = this.pluginsByKeys.get(key);
        Preconditions.checkState(info != null, "Plugin [%s] does not exist", key);
        return info.getInfo();
    }

    @Override
    public Plugin getPluginInstance(String key) {
        Plugin instance = this.pluginInstancesByKeys.get(key);
        Preconditions.checkState(instance != null, "Plugin [%s] does not exist", key);
        return instance;
    }

    @Override
    public Collection<Plugin> getPluginInstances() {
        return this.pluginInstancesByKeys.values();
    }

    @Override
    public boolean hasPlugin(String key) {
        return this.pluginsByKeys.containsKey(key);
    }
}

