/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.impl.utils.ScannerUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scm.ScmConfiguration;

public class ChangedLinesPublisher
implements ReportPublisherStep {
    private static final Logger LOG = Loggers.get(ChangedLinesPublisher.class);
    private static final String LOG_MSG = "SCM writing changed lines";
    private final ScmConfiguration scmConfiguration;
    private final DefaultInputProject project;
    private final InputComponentStore inputComponentStore;
    private final BranchConfiguration branchConfiguration;

    public ChangedLinesPublisher(ScmConfiguration scmConfiguration, DefaultInputProject project, InputComponentStore inputComponentStore, BranchConfiguration branchConfiguration) {
        this.scmConfiguration = scmConfiguration;
        this.project = project;
        this.inputComponentStore = inputComponentStore;
        this.branchConfiguration = branchConfiguration;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        String targetBranchName = this.branchConfiguration.targetBranchName();
        if (this.scmConfiguration.isDisabled() || !this.branchConfiguration.isPullRequest() || targetBranchName == null) {
            return;
        }
        ScmProvider provider = this.scmConfiguration.provider();
        if (provider == null) {
            return;
        }
        Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
        int count = this.writeChangedLines(provider, writer, targetBranchName);
        LOG.debug("SCM reported changed lines for {} {} in the branch", (Object)count, (Object)ScannerUtils.pluralize("file", count));
        profiler.stopInfo();
    }

    private int writeChangedLines(ScmProvider provider, ScannerReportWriter writer, String targetScmBranch) {
        Path rootBaseDir = this.project.getBaseDir();
        Map<Path, DefaultInputFile> changedFiles = StreamSupport.stream(this.inputComponentStore.allChangedFilesToPublish().spliterator(), false).collect(Collectors.toMap(DefaultInputFile::path, f -> f));
        Map<Path, Set<Integer>> pathSetMap = provider.branchChangedLines(targetScmBranch, rootBaseDir, changedFiles.keySet());
        int count = 0;
        if (pathSetMap == null) {
            return count;
        }
        for (Map.Entry<Path, DefaultInputFile> e : changedFiles.entrySet()) {
            DefaultInputFile inputFile = e.getValue();
            Set<Integer> changedLines = pathSetMap.get(e.getKey());
            if (changedLines == null) {
                LOG.warn("File '{}' was detected as changed but without having changed lines", (Object)e.getKey().toAbsolutePath());
                ChangedLinesPublisher.writeChangedLines(writer, e.getValue().scannerId(), Collections.emptySet());
                continue;
            }
            if (changedLines.size() + 1 == inputFile.lines() && inputFile.lineLength(inputFile.lines()) == 0) {
                changedLines.add(inputFile.lines());
            }
            ++count;
            ChangedLinesPublisher.writeChangedLines(writer, e.getValue().scannerId(), changedLines);
        }
        return count;
    }

    private static void writeChangedLines(ScannerReportWriter writer, int fileRef, Set<Integer> changedLines) {
        ScannerReport.ChangedLines.Builder builder = ScannerReport.ChangedLines.newBuilder();
        builder.addAllLine(changedLines);
        writer.writeComponentChangedLines(fileRef, builder.build());
    }
}

