/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.util.Objects;
import java.util.stream.StreamSupport;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.test.TestCase;
import org.sonar.scanner.deprecated.test.DefaultTestPlan;
import org.sonar.scanner.deprecated.test.TestPlanBuilder;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.sensor.DefaultSensorStorage;

public class TestExecutionPublisher
implements ReportPublisherStep {
    private final InputComponentStore componentStore;
    private final TestPlanBuilder testPlanBuilder;

    public TestExecutionPublisher(InputComponentStore componentStore, TestPlanBuilder testPlanBuilder) {
        this.componentStore = componentStore;
        this.testPlanBuilder = testPlanBuilder;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        for (InputComponent c : this.componentStore.all()) {
            DefaultInputComponent component = (DefaultInputComponent)c;
            if (!component.isFile()) continue;
            DefaultInputFile file = (DefaultInputFile)component;
            this.updateTestExecutionFromTestPlan(file, writer);
        }
    }

    private void updateTestExecutionFromTestPlan(InputFile inputFile, ScannerReportWriter writer) {
        DefaultTestPlan testPlan = this.testPlanBuilder.getTestPlanByFile(inputFile);
        if (testPlan == null || !testPlan.testCases().iterator().hasNext()) {
            return;
        }
        long nonSkippedTests = StreamSupport.stream(testPlan.testCases().spliterator(), false).filter(t -> t.status() != TestCase.Status.SKIPPED).count();
        this.appendMeasure(inputFile, writer, (DefaultMeasure)((DefaultMeasure)new DefaultMeasure().forMetric((Metric)CoreMetrics.TESTS)).withValue(Integer.valueOf((int)nonSkippedTests)));
        long executionTime = StreamSupport.stream(testPlan.testCases().spliterator(), false).map(TestCase::durationInMs).filter(Objects::nonNull).mapToLong(Long::longValue).sum();
        this.appendMeasure(inputFile, writer, (DefaultMeasure)((DefaultMeasure)new DefaultMeasure().forMetric((Metric)CoreMetrics.TEST_EXECUTION_TIME)).withValue(Long.valueOf(executionTime)));
        long errorTests = StreamSupport.stream(testPlan.testCases().spliterator(), false).filter(t -> t.status() == TestCase.Status.ERROR).count();
        this.appendMeasure(inputFile, writer, (DefaultMeasure)((DefaultMeasure)new DefaultMeasure().forMetric((Metric)CoreMetrics.TEST_ERRORS)).withValue(Integer.valueOf((int)errorTests)));
        long skippedTests = StreamSupport.stream(testPlan.testCases().spliterator(), false).filter(t -> t.status() == TestCase.Status.SKIPPED).count();
        this.appendMeasure(inputFile, writer, (DefaultMeasure)((DefaultMeasure)new DefaultMeasure().forMetric((Metric)CoreMetrics.SKIPPED_TESTS)).withValue(Integer.valueOf((int)skippedTests)));
        long failedTests = StreamSupport.stream(testPlan.testCases().spliterator(), false).filter(t -> t.status() == TestCase.Status.FAILURE).count();
        this.appendMeasure(inputFile, writer, (DefaultMeasure)((DefaultMeasure)new DefaultMeasure().forMetric((Metric)CoreMetrics.TEST_FAILURES)).withValue(Integer.valueOf((int)failedTests)));
    }

    private void appendMeasure(InputFile inputFile, ScannerReportWriter writer, DefaultMeasure measure) {
        writer.appendComponentMeasure(((DefaultInputComponent)((Object)inputFile)).scannerId(), DefaultSensorStorage.toReportMeasure(measure));
    }
}

