/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import java.time.Instant;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.report.ChangedLinesPublisher;
import org.sonar.scanner.repository.NewCodePeriodLoader;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.ProjectBranches;
import org.sonar.scanner.scm.ScmConfiguration;
import org.sonarqube.ws.NewCodePeriods;

public class ForkDateSupplier {
    private static final Logger LOG = Loggers.get(ChangedLinesPublisher.class);
    private static final String LOG_MSG_WS = "Load New Code definition";
    private final NewCodePeriodLoader newCodePeriodLoader;
    private final BranchConfiguration branchConfiguration;
    private final DefaultInputProject project;
    private final ScmConfiguration scmConfiguration;
    private final ProjectBranches branches;
    private final AnalysisWarnings analysisWarnings;

    public ForkDateSupplier(NewCodePeriodLoader newCodePeriodLoader, BranchConfiguration branchConfiguration, DefaultInputProject project, ScmConfiguration scmConfiguration, ProjectBranches branches, AnalysisWarnings analysisWarnings) {
        this.newCodePeriodLoader = newCodePeriodLoader;
        this.branchConfiguration = branchConfiguration;
        this.project = project;
        this.scmConfiguration = scmConfiguration;
        this.branches = branches;
        this.analysisWarnings = analysisWarnings;
    }

    @CheckForNull
    public Instant get() {
        if (this.branchConfiguration.isPullRequest() || this.branches.isEmpty()) {
            return null;
        }
        Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG_WS);
        String branchName = this.branchConfiguration.branchName() != null ? this.branchConfiguration.branchName() : this.branches.defaultBranchName();
        NewCodePeriods.ShowWSResponse newCode = this.newCodePeriodLoader.load(this.project.key(), branchName);
        profiler.stopInfo();
        if (newCode.getType() != NewCodePeriods.NewCodePeriodType.REFERENCE_BRANCH) {
            return null;
        }
        String referenceBranchName = newCode.getValue();
        if (branchName.equals(referenceBranchName)) {
            LOG.warn("New Code reference branch is set to the branch being analyzed. Skipping the computation of New Code");
            return null;
        }
        LOG.info("Computing New Code since fork with '{}'", (Object)referenceBranchName);
        if (this.scmConfiguration.isDisabled() || this.scmConfiguration.provider() == null) {
            LOG.warn("SCM provider is disabled. No New Code will be computed.");
            this.analysisWarnings.addUnique("The scanner failed to compute New Code because no SCM provider was found. Please check your scanner logs.");
            return null;
        }
        Instant forkdate = this.scmConfiguration.provider().forkDate(referenceBranchName, this.project.getBaseDir());
        if (forkdate != null) {
            LOG.debug("Fork detected at '{}'", (Object)referenceBranchName, (Object)forkdate);
        } else {
            this.analysisWarnings.addUnique("The scanner failed to compute New Code. Please check your scanner logs.");
            LOG.warn("Failed to detect fork date. No New Code will be computed.", (Object)referenceBranchName);
        }
        return forkdate;
    }
}

