/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.component.ComponentKeys;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.sonar.scanner.scan.branch.BranchParamsValidator;

public class ProjectReactorValidator {
    private static final Logger LOG = Loggers.get(ProjectReactorValidator.class);
    private final GlobalConfiguration settings;
    @Nullable
    private final BranchParamsValidator branchParamsValidator;

    public ProjectReactorValidator(GlobalConfiguration settings, @Nullable BranchParamsValidator branchParamsValidator) {
        this.settings = settings;
        this.branchParamsValidator = branchParamsValidator;
    }

    public ProjectReactorValidator(GlobalConfiguration settings) {
        this(settings, null);
    }

    public void validate(ProjectReactor reactor) {
        ArrayList<String> validationMessages = new ArrayList<String>();
        for (ProjectDefinition moduleDef : reactor.getProjects()) {
            ProjectReactorValidator.validateModule(moduleDef);
        }
        if (this.isBranchFeatureAvailable()) {
            this.branchParamsValidator.validate(validationMessages);
        } else {
            this.validateBranchParamsWhenPluginAbsent(validationMessages);
            this.validatePullRequestParamsWhenPluginAbsent(validationMessages);
        }
        if (!validationMessages.isEmpty()) {
            throw MessageException.of("Validation of project reactor failed:\n  o " + String.join((CharSequence)"\n  o ", validationMessages));
        }
    }

    private void validateBranchParamsWhenPluginAbsent(List<String> validationMessages) {
        for (String param : Collections.singletonList("sonar.branch.name")) {
            if (!StringUtils.isNotEmpty(this.settings.get(param).orElse(null))) continue;
            validationMessages.add(String.format("To use the property \"%s\" and analyze branches, Developer Edition or above is required. See %s for more information.", param, "https://redirect.sonarsource.com/doc/branches.html"));
        }
    }

    private void validatePullRequestParamsWhenPluginAbsent(List<String> validationMessages) {
        Stream.of("sonar.pullrequest.key", "sonar.pullrequest.branch", "sonar.pullrequest.base").filter(param -> Objects.nonNull(this.settings.get((String)param).orElse(null))).forEach(param -> validationMessages.add(String.format("To use the property \"%s\" and analyze pull requests, Developer Edition or above is required. See %s for more information.", param, "https://redirect.sonarsource.com/doc/branches.html")));
    }

    private static void validateModule(ProjectDefinition moduleDef) {
        if (!ComponentKeys.isValidProjectKey(moduleDef.getKey())) {
            LOG.warn("\"{}\" is not a valid project or module key. {}.", (Object)moduleDef.getKey(), (Object)"Allowed characters are alphanumeric, '-', '_', '.' and ':', with at least one non-digit");
        }
    }

    private boolean isBranchFeatureAvailable() {
        return this.branchParamsValidator != null;
    }
}

