/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.branch;

import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.scanner.scan.branch.PullRequestInfo;

@Immutable
public class ProjectPullRequests {
    private static final BinaryOperator<PullRequestInfo> PICK_MOST_RECENT_ANALYSIS = (a, b) -> a.getAnalysisDate() < b.getAnalysisDate() ? b : a;
    private final Map<String, PullRequestInfo> pullRequestsByBranchName;

    public ProjectPullRequests(List<PullRequestInfo> pullRequestInfos) {
        this.pullRequestsByBranchName = pullRequestInfos.stream().collect(Collectors.toMap(PullRequestInfo::getBranch, Function.identity(), PICK_MOST_RECENT_ANALYSIS));
    }

    @CheckForNull
    public PullRequestInfo get(String branch) {
        return this.pullRequestsByBranchName.get(branch);
    }

    public boolean isEmpty() {
        return this.pullRequestsByBranchName.isEmpty();
    }
}

