/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.permissions;

import java.util.stream.Collectors;
import org.sonarqube.ws.Permissions;
import org.sonarqube.ws.client.BaseService;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.permissions.AddGroupRequest;
import org.sonarqube.ws.client.permissions.AddGroupToTemplateRequest;
import org.sonarqube.ws.client.permissions.AddProjectCreatorToTemplateRequest;
import org.sonarqube.ws.client.permissions.AddUserRequest;
import org.sonarqube.ws.client.permissions.AddUserToTemplateRequest;
import org.sonarqube.ws.client.permissions.ApplyTemplateRequest;
import org.sonarqube.ws.client.permissions.BulkApplyTemplateRequest;
import org.sonarqube.ws.client.permissions.CreateTemplateRequest;
import org.sonarqube.ws.client.permissions.DeleteTemplateRequest;
import org.sonarqube.ws.client.permissions.GroupsRequest;
import org.sonarqube.ws.client.permissions.RemoveGroupFromTemplateRequest;
import org.sonarqube.ws.client.permissions.RemoveGroupRequest;
import org.sonarqube.ws.client.permissions.RemoveProjectCreatorFromTemplateRequest;
import org.sonarqube.ws.client.permissions.RemoveUserFromTemplateRequest;
import org.sonarqube.ws.client.permissions.RemoveUserRequest;
import org.sonarqube.ws.client.permissions.SearchGlobalPermissionsRequest;
import org.sonarqube.ws.client.permissions.SearchProjectPermissionsRequest;
import org.sonarqube.ws.client.permissions.SearchTemplatesRequest;
import org.sonarqube.ws.client.permissions.SetDefaultTemplateRequest;
import org.sonarqube.ws.client.permissions.TemplateGroupsRequest;
import org.sonarqube.ws.client.permissions.TemplateUsersRequest;
import org.sonarqube.ws.client.permissions.UpdateTemplateRequest;
import org.sonarqube.ws.client.permissions.UsersRequest;

public class PermissionsService
extends BaseService {
    public PermissionsService(WsConnector wsConnector) {
        super(wsConnector, "api/permissions");
    }

    public void addGroup(AddGroupRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("add_group")).setParam("groupId", request.getGroupId())).setParam("groupName", request.getGroupName())).setParam("permission", request.getPermission())).setParam("projectId", request.getProjectId())).setParam("projectKey", request.getProjectKey())).setMediaType("application/json")).content();
    }

    public void addGroupToTemplate(AddGroupToTemplateRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("add_group_to_template")).setParam("groupId", request.getGroupId())).setParam("groupName", request.getGroupName())).setParam("permission", request.getPermission())).setParam("templateId", request.getTemplateId())).setParam("templateName", request.getTemplateName())).setMediaType("application/json")).content();
    }

    public void addProjectCreatorToTemplate(AddProjectCreatorToTemplateRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("add_project_creator_to_template")).setParam("permission", request.getPermission())).setParam("templateId", request.getTemplateId())).setParam("templateName", request.getTemplateName())).setMediaType("application/json")).content();
    }

    public void addUser(AddUserRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("add_user")).setParam("login", request.getLogin())).setParam("permission", request.getPermission())).setParam("projectId", request.getProjectId())).setParam("projectKey", request.getProjectKey())).setMediaType("application/json")).content();
    }

    public void addUserToTemplate(AddUserToTemplateRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("add_user_to_template")).setParam("login", request.getLogin())).setParam("permission", request.getPermission())).setParam("templateId", request.getTemplateId())).setParam("templateName", request.getTemplateName())).setMediaType("application/json")).content();
    }

    public void applyTemplate(ApplyTemplateRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("apply_template")).setParam("projectId", request.getProjectId())).setParam("projectKey", request.getProjectKey())).setParam("templateId", request.getTemplateId())).setParam("templateName", request.getTemplateName())).setMediaType("application/json")).content();
    }

    public void bulkApplyTemplate(BulkApplyTemplateRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("bulk_apply_template")).setParam("analyzedBefore", request.getAnalyzedBefore())).setParam("onProvisionedOnly", request.getOnProvisionedOnly())).setParam("projects", request.getProjects() == null ? null : request.getProjects().stream().collect(Collectors.joining(",")))).setParam("q", request.getQ())).setParam("qualifiers", request.getQualifiers() == null ? null : request.getQualifiers().stream().collect(Collectors.joining(",")))).setParam("templateId", request.getTemplateId())).setParam("templateName", request.getTemplateName())).setParam("visibility", request.getVisibility())).setMediaType("application/json")).content();
    }

    public Permissions.CreateTemplateWsResponse createTemplate(CreateTemplateRequest request) {
        return this.call(((PostRequest)((PostRequest)new PostRequest(this.path("create_template")).setParam("description", request.getDescription())).setParam("name", request.getName())).setParam("projectKeyPattern", request.getProjectKeyPattern()), Permissions.CreateTemplateWsResponse.parser());
    }

    public void deleteTemplate(DeleteTemplateRequest request) {
        this.call(((PostRequest)((PostRequest)new PostRequest(this.path("delete_template")).setParam("templateId", request.getTemplateId())).setParam("templateName", request.getTemplateName())).setMediaType("application/json")).content();
    }

    public Permissions.WsGroupsResponse groups(GroupsRequest request) {
        return this.call(((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("groups")).setParam("p", request.getP())).setParam("permission", request.getPermission())).setParam("projectId", request.getProjectId())).setParam("projectKey", request.getProjectKey())).setParam("ps", request.getPs())).setParam("q", request.getQ()), Permissions.WsGroupsResponse.parser());
    }

    public void removeGroup(RemoveGroupRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("remove_group")).setParam("groupId", request.getGroupId())).setParam("groupName", request.getGroupName())).setParam("permission", request.getPermission())).setParam("projectId", request.getProjectId())).setParam("projectKey", request.getProjectKey())).setMediaType("application/json")).content();
    }

    public void removeGroupFromTemplate(RemoveGroupFromTemplateRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("remove_group_from_template")).setParam("groupId", request.getGroupId())).setParam("groupName", request.getGroupName())).setParam("permission", request.getPermission())).setParam("templateId", request.getTemplateId())).setParam("templateName", request.getTemplateName())).setMediaType("application/json")).content();
    }

    public void removeProjectCreatorFromTemplate(RemoveProjectCreatorFromTemplateRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("remove_project_creator_from_template")).setParam("permission", request.getPermission())).setParam("templateId", request.getTemplateId())).setParam("templateName", request.getTemplateName())).setMediaType("application/json")).content();
    }

    public void removeUser(RemoveUserRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("remove_user")).setParam("login", request.getLogin())).setParam("permission", request.getPermission())).setParam("projectId", request.getProjectId())).setParam("projectKey", request.getProjectKey())).setMediaType("application/json")).content();
    }

    public void removeUserFromTemplate(RemoveUserFromTemplateRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("remove_user_from_template")).setParam("login", request.getLogin())).setParam("permission", request.getPermission())).setParam("templateId", request.getTemplateId())).setParam("templateName", request.getTemplateName())).setMediaType("application/json")).content();
    }

    @Deprecated
    public Permissions.WsSearchGlobalPermissionsResponse searchGlobalPermissions(SearchGlobalPermissionsRequest request) {
        return this.call(new GetRequest(this.path("search_global_permissions")), Permissions.WsSearchGlobalPermissionsResponse.parser());
    }

    @Deprecated
    public Permissions.SearchProjectPermissionsWsResponse searchProjectPermissions(SearchProjectPermissionsRequest request) {
        return this.call(((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("search_project_permissions")).setParam("p", request.getP())).setParam("projectId", request.getProjectId())).setParam("projectKey", request.getProjectKey())).setParam("ps", request.getPs())).setParam("q", request.getQ())).setParam("qualifier", request.getQualifier()), Permissions.SearchProjectPermissionsWsResponse.parser());
    }

    public Permissions.SearchTemplatesWsResponse searchTemplates(SearchTemplatesRequest request) {
        return this.call(new GetRequest(this.path("search_templates")).setParam("q", request.getQ()), Permissions.SearchTemplatesWsResponse.parser());
    }

    public void setDefaultTemplate(SetDefaultTemplateRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("set_default_template")).setParam("qualifier", request.getQualifier())).setParam("templateId", request.getTemplateId())).setParam("templateName", request.getTemplateName())).setMediaType("application/json")).content();
    }

    public Permissions.WsTemplateGroupsResponse templateGroups(TemplateGroupsRequest request) {
        return this.call(((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("template_groups")).setParam("p", request.getP())).setParam("permission", request.getPermission())).setParam("ps", request.getPs())).setParam("q", request.getQ())).setParam("templateId", request.getTemplateId())).setParam("templateName", request.getTemplateName()), Permissions.WsTemplateGroupsResponse.parser());
    }

    public String templateUsers(TemplateUsersRequest request) {
        return this.call(((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("template_users")).setParam("p", request.getP())).setParam("permission", request.getPermission())).setParam("ps", request.getPs())).setParam("q", request.getQ())).setParam("templateId", request.getTemplateId())).setParam("templateName", request.getTemplateName())).setMediaType("application/json")).content();
    }

    public Permissions.UpdateTemplateWsResponse updateTemplate(UpdateTemplateRequest request) {
        return this.call(((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("update_template")).setParam("description", request.getDescription())).setParam("id", request.getId())).setParam("name", request.getName())).setParam("projectKeyPattern", request.getProjectKeyPattern()), Permissions.UpdateTemplateWsResponse.parser());
    }

    public Permissions.UsersWsResponse users(UsersRequest request) {
        return this.call(((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("users")).setParam("p", request.getP())).setParam("permission", request.getPermission())).setParam("projectId", request.getProjectId())).setParam("projectKey", request.getProjectKey())).setParam("ps", request.getPs())).setParam("q", request.getQ()), Permissions.UsersWsResponse.parser());
    }
}

