/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.vdbe;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetCallback;
import org.tmatesoft.sqljet.core.internal.ISqlJetCollSeq;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetFuncDef;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetRowSet;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetRowSet;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemFlags;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetVdbeMemPool;
import org.tmatesoft.sqljet.core.schema.SqlJetTypeAffinity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetVdbeMem
extends SqlJetCloneable
implements ISqlJetVdbeMem {
    public static long instanceCounter = 0L;
    long i;
    int nZero;
    ISqlJetFuncDef pDef;
    ISqlJetRowSet pRowSet;
    double r;
    ISqlJetDbHandle db = null;
    ISqlJetMemoryPointer z;
    int n;
    EnumSet<SqlJetVdbeMemFlags> flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
    SqlJetValueType type = SqlJetValueType.NULL;
    SqlJetEncoding enc;
    ISqlJetCallback xDel;
    ISqlJetMemoryPointer zMalloc;
    public static final SqlJetVdbeMemPool pool = new SqlJetVdbeMemPool();

    public static SqlJetVdbeMem obtainInstance() {
        return pool.obtain();
    }

    SqlJetVdbeMem(SqlJetVdbeMemPool pool) {
    }

    @Override
    public void reset() {
        this.z = null;
        this.zMalloc = null;
        this.xDel = null;
    }

    @Override
    public void release() {
        this.i = 0L;
        this.nZero = 0;
        this.pDef = null;
        this.pRowSet = null;
        this.r = 0.0;
        this.db = null;
        this.z = null;
        this.n = 0;
        this.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
        this.type = SqlJetValueType.NULL;
        this.enc = null;
        this.xDel = null;
        this.zMalloc = null;
        pool.release(this);
    }

    public static int compare(SqlJetVdbeMem pMem1, SqlJetVdbeMem pMem2, ISqlJetCollSeq pColl) throws SqlJetException {
        int rc;
        EnumSet<SqlJetVdbeMemFlags> f1 = pMem1.flags;
        EnumSet<SqlJetVdbeMemFlags> f2 = pMem2.flags;
        EnumSet<SqlJetVdbeMemFlags> combined_flags = EnumSet.copyOf(f1);
        combined_flags.addAll(f2);
        assert (!combined_flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        if (combined_flags.contains((Object)SqlJetVdbeMemFlags.Null)) {
            return (f2.contains((Object)SqlJetVdbeMemFlags.Null) ? 1 : 0) - (f1.contains((Object)SqlJetVdbeMemFlags.Null) ? 1 : 0);
        }
        if (combined_flags.contains((Object)SqlJetVdbeMemFlags.Int) || combined_flags.contains((Object)SqlJetVdbeMemFlags.Real)) {
            if (!f1.contains((Object)SqlJetVdbeMemFlags.Int) && !f1.contains((Object)SqlJetVdbeMemFlags.Real)) {
                return 1;
            }
            if (!f2.contains((Object)SqlJetVdbeMemFlags.Int) && !f2.contains((Object)SqlJetVdbeMemFlags.Real)) {
                return -1;
            }
            if (f1.contains((Object)SqlJetVdbeMemFlags.Real) || f2.contains((Object)SqlJetVdbeMemFlags.Real)) {
                double r2;
                double r1 = !f1.contains((Object)SqlJetVdbeMemFlags.Real) ? (double)pMem1.i : pMem1.r;
                if (r1 < (r2 = !f2.contains((Object)SqlJetVdbeMemFlags.Real) ? (double)pMem2.i : pMem2.r)) {
                    return -1;
                }
                if (r1 > r2) {
                    return 1;
                }
                return 0;
            }
            assert (f1.contains((Object)SqlJetVdbeMemFlags.Int));
            assert (f2.contains((Object)SqlJetVdbeMemFlags.Int));
            if (pMem1.i < pMem2.i) {
                return -1;
            }
            if (pMem1.i > pMem2.i) {
                return 1;
            }
            return 0;
        }
        if (combined_flags.contains((Object)SqlJetVdbeMemFlags.Str)) {
            if (!f1.contains((Object)SqlJetVdbeMemFlags.Str)) {
                return 1;
            }
            if (!f2.contains((Object)SqlJetVdbeMemFlags.Str)) {
                return -1;
            }
            assert (pMem1.enc == pMem2.enc);
            assert (pMem1.enc == SqlJetEncoding.UTF8 || pMem1.enc == SqlJetEncoding.UTF16LE || pMem1.enc == SqlJetEncoding.UTF16BE);
            if (pColl != null) {
                if (pMem1.enc == pColl.getEnc()) {
                    return pColl.cmp(pColl.getUserData(), pMem1.n, pMem1.z, pMem2.n, pMem2.z);
                }
                SqlJetVdbeMem c1 = (SqlJetVdbeMem)pMem1.shallowCopy(SqlJetVdbeMemFlags.Ephem);
                SqlJetVdbeMem c2 = (SqlJetVdbeMem)pMem2.shallowCopy(SqlJetVdbeMemFlags.Ephem);
                ISqlJetMemoryPointer v1 = c1.valueText(pColl.getEnc());
                int n1 = v1 == null ? 0 : c1.n;
                ISqlJetMemoryPointer v2 = c2.valueText(pColl.getEnc());
                int n2 = v2 == null ? 0 : c2.n;
                c1.reset();
                c2.reset();
                return pColl.cmp(pColl.getUserData(), n1, v1, n2, v2);
            }
        }
        if ((rc = SqlJetUtility.memcmp(pMem1.z, pMem2.z, pMem1.n > pMem2.n ? pMem2.n : pMem1.n)) == 0) {
            rc = pMem1.n - pMem2.n;
        }
        return rc;
    }

    @Override
    public ISqlJetVdbeMem shallowCopy(SqlJetVdbeMemFlags srcType) throws SqlJetException {
        SqlJetVdbeMem pFrom = this;
        assert (!pFrom.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        SqlJetVdbeMem pTo = SqlJetUtility.memcpy(pFrom);
        if (pFrom.flags.contains((Object)SqlJetVdbeMemFlags.Dyn) || pFrom.z == pFrom.zMalloc) {
            pTo.flags.removeAll(SqlJetUtility.of(SqlJetVdbeMemFlags.Dyn, SqlJetVdbeMemFlags.Static, SqlJetVdbeMemFlags.Ephem));
            assert (srcType == SqlJetVdbeMemFlags.Ephem || srcType == SqlJetVdbeMemFlags.Static);
            pTo.flags.add(srcType);
        }
        return pTo;
    }

    @Override
    public ISqlJetVdbeMem copy() throws SqlJetException {
        SqlJetVdbeMem pFrom = this;
        assert (!pFrom.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        SqlJetVdbeMem pTo = SqlJetUtility.memcpy(pFrom);
        pTo.flags.remove((Object)SqlJetVdbeMemFlags.Dyn);
        if ((pTo.flags.contains((Object)SqlJetVdbeMemFlags.Str) || pTo.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) && !pFrom.flags.contains((Object)SqlJetVdbeMemFlags.Static)) {
            pTo.flags.add(SqlJetVdbeMemFlags.Ephem);
            pTo.makeWriteable();
        }
        return pTo;
    }

    @Override
    public ISqlJetVdbeMem move() throws SqlJetException {
        assert (this.db == null || SqlJetUtility.mutex_held(this.db.getMutex()));
        SqlJetVdbeMem pTo = SqlJetUtility.memcpy(this);
        this.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
        this.xDel = null;
        this.zMalloc = null;
        return pTo;
    }

    @Override
    public ISqlJetMemoryPointer valueText(SqlJetEncoding enc) throws SqlJetException {
        SqlJetVdbeMem pVal = this;
        assert (pVal.db == null || SqlJetUtility.mutex_held(pVal.db.getMutex()));
        assert (!pVal.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        if (pVal.flags.contains((Object)SqlJetVdbeMemFlags.Null)) {
            return null;
        }
        if (pVal.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) {
            pVal.flags.add(SqlJetVdbeMemFlags.Str);
        }
        pVal.expandBlob();
        if (pVal.flags.contains((Object)SqlJetVdbeMemFlags.Str)) {
            pVal.changeEncoding(enc);
            pVal.makeWriteable();
            pVal.nulTerminate();
        } else {
            assert (!pVal.flags.contains((Object)SqlJetVdbeMemFlags.Blob));
            pVal.stringify(enc);
        }
        return pVal.z;
    }

    @Override
    public void stringify(SqlJetEncoding enc) throws SqlJetException {
        SqlJetVdbeMem pMem = this;
        EnumSet<SqlJetVdbeMemFlags> fg = pMem.flags;
        int nByte = 32;
        assert (pMem.db == null || SqlJetUtility.mutex_held(pMem.db.getMutex()));
        assert (!fg.contains((Object)SqlJetVdbeMemFlags.Zero));
        assert (!fg.contains((Object)SqlJetVdbeMemFlags.Str) && !fg.contains((Object)SqlJetVdbeMemFlags.Blob));
        assert (fg.contains((Object)SqlJetVdbeMemFlags.Int) || fg.contains((Object)SqlJetVdbeMemFlags.Real));
        assert (!pMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        pMem.grow(32, false);
        if (fg.contains((Object)SqlJetVdbeMemFlags.Int)) {
            pMem.z.putBytes(Long.toString(pMem.i).getBytes());
        } else {
            assert (fg.contains((Object)SqlJetVdbeMemFlags.Real));
            pMem.z.putBytes(Double.toString(pMem.r).getBytes());
        }
        pMem.n = SqlJetUtility.strlen30(pMem.z);
        pMem.enc = SqlJetEncoding.UTF8;
        pMem.flags.add(SqlJetVdbeMemFlags.Str);
        pMem.flags.add(SqlJetVdbeMemFlags.Term);
        pMem.changeEncoding(enc);
        this.type = SqlJetValueType.TEXT;
    }

    @Override
    public void grow(int n, boolean preserve) {
        SqlJetVdbeMem pMem = this;
        assert (1 >= (pMem.zMalloc != null && pMem.zMalloc == pMem.z ? 1 : 0) + (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Dyn) && pMem.xDel != null ? 1 : 0) + (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Ephem) ? 1 : 0) + (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Static) ? 1 : 0));
        assert (!pMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        if (n < 32) {
            n = 32;
        }
        pMem.zMalloc = SqlJetUtility.allocatePtr(n);
        if (preserve && pMem.z != null) {
            SqlJetUtility.memcpy(pMem.zMalloc, pMem.z, pMem.n);
        }
        if (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Dyn) && pMem.xDel != null) {
            pMem.xDel.call(pMem.z);
        }
        pMem.z = pMem.zMalloc;
        if (pMem.z == null) {
            pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
        } else {
            pMem.flags.remove((Object)SqlJetVdbeMemFlags.Ephem);
            pMem.flags.remove((Object)SqlJetVdbeMemFlags.Static);
        }
        pMem.xDel = null;
    }

    @Override
    public void nulTerminate() {
        SqlJetVdbeMem pMem = this;
        assert (pMem.db == null || SqlJetUtility.mutex_held(pMem.db.getMutex()));
        if (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Term) || !pMem.flags.contains((Object)SqlJetVdbeMemFlags.Str)) {
            return;
        }
        pMem.grow(pMem.n + 2, true);
        pMem.z.putByte(pMem.n, (byte)0);
        pMem.z.putByte(pMem.n + 1, (byte)0);
        pMem.flags.add(SqlJetVdbeMemFlags.Term);
        pMem.z.limit(pMem.n);
    }

    @Override
    public void changeEncoding(SqlJetEncoding desiredEnc) throws SqlJetException {
        SqlJetVdbeMem pMem = this;
        assert (!pMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        assert (desiredEnc == SqlJetEncoding.UTF8 || desiredEnc == SqlJetEncoding.UTF16LE || desiredEnc == SqlJetEncoding.UTF16BE);
        if (!pMem.flags.contains((Object)SqlJetVdbeMemFlags.Str) || pMem.enc == desiredEnc) {
            return;
        }
        assert (pMem.db == null || SqlJetUtility.mutex_held(pMem.db.getMutex()));
        pMem.translate(desiredEnc);
    }

    @Override
    public void translate(SqlJetEncoding desiredEnc) throws SqlJetException {
        int len;
        SqlJetVdbeMem pMem = this;
        assert (pMem.db == null || SqlJetUtility.mutex_held(pMem.db.getMutex()));
        assert (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Str));
        assert (pMem.enc != desiredEnc);
        assert (pMem.enc != null);
        assert (pMem.n >= 0);
        if (pMem.enc != SqlJetEncoding.UTF8 && desiredEnc != SqlJetEncoding.UTF8) {
            pMem.makeWriteable();
            int zTerm = pMem.n & 0xFFFFFFFE;
            for (int zIn = 0; zIn < zTerm; ++zIn) {
                short temp = (short)SqlJetUtility.getUnsignedByte(pMem.z, zIn);
                SqlJetUtility.putUnsignedByte(pMem.z, zIn, SqlJetUtility.getUnsignedByte(pMem.z, zIn + 1));
                int n = ++zIn;
                SqlJetUtility.putUnsignedByte(pMem.z, n, temp);
            }
            pMem.enc = desiredEnc;
            return;
        }
        if (desiredEnc == SqlJetEncoding.UTF8) {
            pMem.n &= 0xFFFFFFFE;
            len = pMem.n * 2 + 1;
        } else {
            len = pMem.n * 2 + 2;
        }
        ISqlJetMemoryPointer zOut = SqlJetUtility.translate(pMem.z, pMem.enc, desiredEnc);
        pMem.n = zOut.remaining();
        assert (pMem.n + (desiredEnc == SqlJetEncoding.UTF8 ? 1 : 2) <= len);
        pMem.reset();
        pMem.flags.removeAll(SqlJetUtility.of(SqlJetVdbeMemFlags.Static, SqlJetVdbeMemFlags.Dyn, SqlJetVdbeMemFlags.Ephem));
        pMem.enc = desiredEnc;
        pMem.flags.addAll(SqlJetUtility.of(SqlJetVdbeMemFlags.Term, SqlJetVdbeMemFlags.Dyn));
        pMem.zMalloc = pMem.z = zOut;
    }

    @Override
    public void expandBlob() {
        SqlJetVdbeMem pMem = this;
        if (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Zero)) {
            assert (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob));
            assert (!pMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
            assert (pMem.db == null || SqlJetUtility.mutex_held(pMem.db.getMutex()));
            int nByte = pMem.n + pMem.nZero;
            if (nByte <= 0) {
                nByte = 1;
            }
            pMem.grow(nByte, true);
            SqlJetUtility.memset(pMem.z, pMem.n, (byte)0, pMem.nZero);
            pMem.n += pMem.nZero;
            pMem.flags.removeAll(SqlJetUtility.of(SqlJetVdbeMemFlags.Zero, SqlJetVdbeMemFlags.Term));
        }
    }

    @Override
    public void fromBtree(ISqlJetBtreeCursor pCur, int offset, int amt, boolean key) throws SqlJetException {
        assert (SqlJetUtility.mutex_held(pCur.getCursorDb().getMutex()));
        SqlJetVdbeMem pMem = this;
        int[] available = new int[]{0};
        ISqlJetMemoryPointer zData = key ? pCur.keyFetch(available) : pCur.dataFetch(available);
        assert (zData != null);
        if (offset + amt <= available[0]) {
            pMem.reset();
            pMem.z = SqlJetUtility.pointer(zData, offset);
            pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Blob, SqlJetVdbeMemFlags.Ephem);
        } else {
            pMem.grow(amt + 2, false);
            pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Blob, SqlJetVdbeMemFlags.Dyn, SqlJetVdbeMemFlags.Term);
            pMem.enc = null;
            pMem.type = SqlJetValueType.BLOB;
            try {
                if (key) {
                    pCur.key(offset, amt, pMem.z);
                } else {
                    pCur.data(offset, amt, pMem.z);
                }
            }
            catch (SqlJetException e) {
                pMem.reset();
                throw e;
            }
            finally {
                if (pMem.z != null) {
                    SqlJetUtility.putUnsignedByte(pMem.z, amt, 0);
                    SqlJetUtility.putUnsignedByte(pMem.z, amt + 1, 0);
                }
            }
        }
        pMem.n = amt;
    }

    @Override
    public void makeWriteable() {
        SqlJetVdbeMem pMem = this;
        assert (pMem.db == null || SqlJetUtility.mutex_held(pMem.db.getMutex()));
        assert (!pMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        pMem.expandBlob();
        if ((pMem.flags.contains((Object)SqlJetVdbeMemFlags.Str) || pMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) && pMem.z != pMem.zMalloc) {
            pMem.grow(pMem.n + 2, true);
            SqlJetUtility.putUnsignedByte(pMem.z, pMem.n, 0);
            SqlJetUtility.putUnsignedByte(pMem.z, pMem.n + 1, 0);
            pMem.flags.add(SqlJetVdbeMemFlags.Term);
            pMem.z.limit(pMem.n);
        }
    }

    @Override
    public long intValue() {
        assert (this.db == null || SqlJetUtility.mutex_held(this.db.getMutex()));
        if (this.flags.contains((Object)SqlJetVdbeMemFlags.Int)) {
            return this.i;
        }
        if (this.flags.contains((Object)SqlJetVdbeMemFlags.Real)) {
            return (long)this.r;
        }
        if (this.flags.contains((Object)SqlJetVdbeMemFlags.Str) || this.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) {
            long value = 0L;
            this.flags.add(SqlJetVdbeMemFlags.Str);
            try {
                this.changeEncoding(SqlJetEncoding.UTF8);
                this.nulTerminate();
            }
            catch (SqlJetException e) {
                return 0L;
            }
            value = SqlJetUtility.atoi64(SqlJetUtility.toString(this.z));
            return value;
        }
        return 0L;
    }

    @Override
    public void setNull() {
        if (this.flags.contains((Object)SqlJetVdbeMemFlags.RowSet)) {
            // empty if block
        }
        this.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Null);
        this.type = SqlJetValueType.NULL;
    }

    @Override
    public void setStr(ISqlJetMemoryPointer z, SqlJetEncoding enc) throws SqlJetException {
        assert (this.db == null || SqlJetUtility.mutex_held(this.db.getMutex()));
        assert (!this.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        if (z == null) {
            this.setNull();
            return;
        }
        int nByte = z.remaining();
        int iLimit = 1000000000;
        this.flags = SqlJetUtility.noneOf(SqlJetVdbeMemFlags.class);
        this.flags.add(enc == null ? SqlJetVdbeMemFlags.Blob : SqlJetVdbeMemFlags.Str);
        if (nByte > iLimit) {
            throw new SqlJetException(SqlJetErrorCode.TOOBIG);
        }
        this.z = z;
        this.n = nByte;
        this.enc = enc == null ? SqlJetEncoding.UTF8 : enc;
        this.type = enc == null ? SqlJetValueType.BLOB : SqlJetValueType.TEXT;
    }

    @Override
    public void setInt64(long val) {
        this.reset();
        this.i = val;
        this.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Int);
        this.type = SqlJetValueType.INTEGER;
    }

    @Override
    public double realValue() {
        SqlJetVdbeMem pMem = this;
        assert (pMem.db == null || pMem.db.getMutex().held());
        if (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Real)) {
            return pMem.r;
        }
        if (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Int)) {
            return pMem.i;
        }
        if (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Str) || pMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) {
            double val = 0.0;
            pMem.flags.add(SqlJetVdbeMemFlags.Str);
            try {
                pMem.changeEncoding(SqlJetEncoding.UTF8);
                pMem.nulTerminate();
            }
            catch (SqlJetException e) {
                return 0.0;
            }
            assert (pMem.z != null);
            val = SqlJetUtility.atof(pMem.z);
            return val;
        }
        return 0.0;
    }

    @Override
    public void integerAffinity() {
        SqlJetVdbeMem pMem = this;
        assert (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Real));
        assert (!pMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        assert (pMem.db == null || pMem.db.getMutex().held());
        pMem.i = (long)pMem.r;
        if (pMem.r == (double)pMem.i) {
            pMem.flags.add(SqlJetVdbeMemFlags.Int);
            this.type = SqlJetValueType.INTEGER;
        }
    }

    @Override
    public void integerify() {
        SqlJetVdbeMem pMem = this;
        assert (pMem.db == null || pMem.db.getMutex().held());
        assert (!pMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        pMem.i = pMem.intValue();
        pMem.setTypeFlag(SqlJetVdbeMemFlags.Int);
        this.type = SqlJetValueType.INTEGER;
    }

    @Override
    public void realify() {
        SqlJetVdbeMem pMem = this;
        assert (pMem.db == null || pMem.db.getMutex().held());
        pMem.r = pMem.realValue();
        pMem.setTypeFlag(SqlJetVdbeMemFlags.Real);
        this.type = SqlJetValueType.FLOAT;
    }

    @Override
    public void numerify() {
        long i;
        double r2;
        SqlJetVdbeMem pMem = this;
        assert (!(pMem.flags.contains((Object)SqlJetVdbeMemFlags.Int) || pMem.flags.contains((Object)SqlJetVdbeMemFlags.Real) || pMem.flags.contains((Object)SqlJetVdbeMemFlags.Null)));
        assert (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Str) || pMem.flags.contains((Object)SqlJetVdbeMemFlags.Blob));
        assert (pMem.db == null || pMem.db.getMutex().held());
        double r1 = pMem.realValue();
        if (r1 == (r2 = (double)(i = (long)r1))) {
            pMem.integerify();
        } else {
            pMem.r = r1;
            pMem.setTypeFlag(SqlJetVdbeMemFlags.Real);
            this.type = SqlJetValueType.FLOAT;
        }
    }

    @Override
    public void setTypeFlag(SqlJetVdbeMemFlags f) {
        Iterator iterator2 = this.flags.iterator();
        while (iterator2.hasNext()) {
            SqlJetVdbeMemFlags flag = (SqlJetVdbeMemFlags)((Object)iterator2.next());
            if (flag.ordinal() >= SqlJetVdbeMemFlags.TypeMask.ordinal() && flag != SqlJetVdbeMemFlags.Zero) continue;
            iterator2.remove();
        }
        this.flags.add(f);
    }

    @Override
    public void setZeroBlob(int n) {
        SqlJetVdbeMem pMem = this;
        pMem.reset();
        pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Blob, SqlJetVdbeMemFlags.Zero);
        pMem.type = SqlJetValueType.BLOB;
        pMem.n = 0;
        if (n < 0) {
            n = 0;
        }
        pMem.nZero = n;
        pMem.enc = SqlJetEncoding.UTF8;
    }

    @Override
    public void setDouble(double val) {
        SqlJetVdbeMem pMem = this;
        if (Double.isNaN(val)) {
            pMem.setNull();
        } else {
            pMem.reset();
            pMem.r = val;
            pMem.flags = SqlJetUtility.of(SqlJetVdbeMemFlags.Real);
            pMem.type = SqlJetValueType.FLOAT;
        }
    }

    @Override
    public void setRowSet() {
        SqlJetVdbeMem pMem = this;
        ISqlJetDbHandle db = pMem.db;
        assert (db != null);
        if (pMem.flags.contains((Object)SqlJetVdbeMemFlags.RowSet)) {
            pMem.pRowSet.clear();
        } else {
            pMem.reset();
            pMem.pRowSet = new SqlJetRowSet(db);
            pMem.flags.add(SqlJetVdbeMemFlags.RowSet);
        }
    }

    @Override
    public boolean isTooBig() {
        SqlJetVdbeMem p = this;
        assert (p.db != null);
        if (p.flags.contains((Object)SqlJetVdbeMemFlags.Str) || p.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) {
            int n = p.n;
            if (p.flags.contains((Object)SqlJetVdbeMemFlags.Zero)) {
                n += p.nZero;
            }
            return n > 1000000000;
        }
        return false;
    }

    @Override
    public void sanity() {
        SqlJetVdbeMem pMem = this;
        EnumSet<SqlJetVdbeMemFlags> flags = pMem.flags;
        assert (flags != null && flags.size() > 0);
        if (flags.contains((Object)SqlJetVdbeMemFlags.Str) || flags.contains((Object)SqlJetVdbeMemFlags.Blob)) {
            int x = (flags.contains((Object)SqlJetVdbeMemFlags.Static) ? 1 : 0) + (flags.contains((Object)SqlJetVdbeMemFlags.Dyn) ? 1 : 0) + (flags.contains((Object)SqlJetVdbeMemFlags.Ephem) ? 1 : 0);
            assert (x == 1);
            assert (pMem.z != null);
            assert (pMem.xDel == null || flags.contains((Object)SqlJetVdbeMemFlags.Dyn));
            if (flags.contains((Object)SqlJetVdbeMemFlags.Str)) {
                assert (pMem.enc == SqlJetEncoding.UTF8 || pMem.enc == SqlJetEncoding.UTF16BE || pMem.enc == SqlJetEncoding.UTF16LE);
                if (pMem.enc == SqlJetEncoding.UTF8 && flags.contains((Object)SqlJetVdbeMemFlags.Term)) {
                    assert (SqlJetUtility.strlen30(pMem.z) <= pMem.n);
                    assert (SqlJetUtility.getUnsignedByte(pMem.z, pMem.n) == 0);
                }
            }
        } else {
            assert (!(pMem.flags.contains((Object)SqlJetVdbeMemFlags.Static) || pMem.flags.contains((Object)SqlJetVdbeMemFlags.Dyn) || pMem.flags.contains((Object)SqlJetVdbeMemFlags.Ephem)));
            assert (pMem.xDel == null);
        }
        assert (!pMem.flags.contains((Object)SqlJetVdbeMemFlags.Static) && !pMem.flags.contains((Object)SqlJetVdbeMemFlags.Dyn) && !pMem.flags.contains((Object)SqlJetVdbeMemFlags.Ephem) || !pMem.flags.contains((Object)SqlJetVdbeMemFlags.Null));
        assert (pMem.flags.contains((Object)SqlJetVdbeMemFlags.Int) && pMem.flags.contains((Object)SqlJetVdbeMemFlags.Real) && pMem.r == (double)pMem.i);
    }

    @Override
    public int valueBytes(SqlJetEncoding enc) throws SqlJetException {
        SqlJetVdbeMem p = this;
        if (p.flags.contains((Object)SqlJetVdbeMemFlags.Blob) || p.valueText(enc) != null) {
            if (p.flags.contains((Object)SqlJetVdbeMemFlags.Zero)) {
                return p.n + p.nZero;
            }
            return p.n;
        }
        return 0;
    }

    @Override
    public void handleBom() {
        SqlJetVdbeMem pMem = this;
        SqlJetEncoding bom = null;
        if (pMem.n < 0 || pMem.n > 1) {
            short b1 = (short)SqlJetUtility.getUnsignedByte(pMem.z, 0);
            short b2 = (short)SqlJetUtility.getUnsignedByte(pMem.z, 1);
            if (b1 == 254 && b2 == 255) {
                bom = SqlJetEncoding.UTF16BE;
            }
            if (b1 == 255 && b2 == 254) {
                bom = SqlJetEncoding.UTF16LE;
            }
        }
        if (null != bom) {
            pMem.makeWriteable();
            pMem.n -= 2;
            SqlJetUtility.memmove(pMem.z, 0, pMem.z, 2, pMem.n);
            SqlJetUtility.putUnsignedByte(pMem.z, pMem.n, 0);
            SqlJetUtility.putUnsignedByte(pMem.z, pMem.n + 1, 0);
            pMem.flags.add(SqlJetVdbeMemFlags.Term);
            pMem.enc = bom;
        }
    }

    @Override
    public Set<SqlJetVdbeMemFlags> getFlags() {
        return this.flags;
    }

    @Override
    public boolean isNull() {
        if (null == this.flags) {
            return true;
        }
        return this.flags.contains((Object)SqlJetVdbeMemFlags.Null);
    }

    @Override
    public SqlJetValueType getType() {
        return this.type;
    }

    @Override
    public ISqlJetMemoryPointer valueBlob() throws SqlJetException {
        if (this.flags.contains((Object)SqlJetVdbeMemFlags.Str) || this.flags.contains((Object)SqlJetVdbeMemFlags.Blob)) {
            this.expandBlob();
            this.flags.remove((Object)SqlJetVdbeMemFlags.Str);
            this.flags.add(SqlJetVdbeMemFlags.Blob);
            this.z.limit(this.n);
            return this.z;
        }
        return this.valueText(SqlJetEncoding.UTF8);
    }

    @Override
    public void applyAffinity(SqlJetTypeAffinity affinity, SqlJetEncoding enc) throws SqlJetException {
        if (affinity == SqlJetTypeAffinity.TEXT) {
            if (!this.flags.contains((Object)SqlJetVdbeMemFlags.Str) && (this.flags.contains((Object)SqlJetVdbeMemFlags.Real) || this.flags.contains((Object)SqlJetVdbeMemFlags.Int))) {
                this.stringify(enc);
            }
            this.flags.remove((Object)SqlJetVdbeMemFlags.Real);
            this.flags.remove((Object)SqlJetVdbeMemFlags.Int);
        } else if (affinity != SqlJetTypeAffinity.NONE) {
            assert (affinity == SqlJetTypeAffinity.INTEGER || affinity == SqlJetTypeAffinity.REAL || affinity == SqlJetTypeAffinity.NUMERIC);
            this.applyNumericAffinity();
        }
    }

    public void applyNumericAffinity() throws SqlJetException {
        if (!this.flags.contains((Object)SqlJetVdbeMemFlags.Real) && !this.flags.contains((Object)SqlJetVdbeMemFlags.Int)) {
            boolean[] realnum = new boolean[]{false};
            this.nulTerminate();
            if (this.flags.contains((Object)SqlJetVdbeMemFlags.Str) && SqlJetUtility.isNumber(SqlJetUtility.toString(this.z, this.enc), realnum)) {
                Long value;
                this.changeEncoding(SqlJetEncoding.UTF8);
                if (!realnum[0] && (value = SqlJetUtility.atoi64(SqlJetUtility.toString(this.z))) != null) {
                    this.i = value;
                    this.setTypeFlag(SqlJetVdbeMemFlags.Int);
                    this.type = SqlJetValueType.INTEGER;
                } else {
                    this.realify();
                }
            }
        } else if (this.type != SqlJetValueType.INTEGER && this.type != SqlJetValueType.FLOAT) {
            if (this.flags.contains((Object)SqlJetVdbeMemFlags.Int)) {
                this.type = SqlJetValueType.INTEGER;
            } else if (this.flags.contains((Object)SqlJetVdbeMemFlags.Real)) {
                this.type = SqlJetValueType.FLOAT;
            }
        }
    }

    void applyIntegerAffinity() {
        assert (this.flags.contains((Object)SqlJetVdbeMemFlags.Real));
        assert (!this.flags.contains((Object)SqlJetVdbeMemFlags.RowSet));
        assert (this.db == null || SqlJetUtility.mutex_held(this.db.getMutex()));
        Long l = SqlJetUtility.doubleToInt64(this.r);
        if (l != null) {
            this.i = l;
            this.flags.add(SqlJetVdbeMemFlags.Int);
            this.type = SqlJetValueType.INTEGER;
        }
    }
}

