/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCopyDriver;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCopyClient16
extends SVNCopyDriver {
    protected ISVNCommitHandler myCommitHandler;
    protected ISVNCommitParameters myCommitParameters;
    protected ISVNExternalsHandler myExternalsHandler;

    public SVNCopyClient16(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNCopyClient16(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setCommitHandler(ISVNCommitHandler handler) {
        this.myCommitHandler = handler;
    }

    public ISVNCommitHandler getCommitHandler() {
        return this.myCommitHandler;
    }

    public void setCommitParameters(ISVNCommitParameters parameters) {
        this.myCommitParameters = parameters;
    }

    public ISVNCommitParameters getCommitParameters() {
        return this.myCommitParameters;
    }

    public void setExternalsHandler(ISVNExternalsHandler externalsHandler) {
        this.myExternalsHandler = externalsHandler;
    }

    public ISVNExternalsHandler getExternalsHandler() {
        if (this.myExternalsHandler == null) {
            return ISVNExternalsHandler.DEFAULT;
        }
        return this.myExternalsHandler;
    }

    public void doCopy(SVNCopySource[] sources, File dst, boolean isMove, boolean makeParents, boolean failWhenDstExists) throws SVNException {
        this.doCopy(sources, dst, isMove, makeParents, failWhenDstExists, false, null);
    }

    private void doCopy(SVNCopySource[] sources, File dst, boolean isMove, boolean makeParents, boolean failWhenDstExists, boolean pinExternals, Map<SvnTarget, List<SVNExternal>> externalsToPin) throws SVNException {
        if (sources.length > 1 && failWhenDstExists) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MULTIPLE_SOURCES_DISALLOWED);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if ((sources = this.expandCopySources(sources)).length == 0) {
            return;
        }
        try {
            this.setupCopy(sources, new SVNPath(dst.getAbsolutePath(), false, false), isMove, makeParents, pinExternals, externalsToPin, null, null, this.getCommitHandler(), this.getCommitParameters(), this.getExternalsHandler());
        }
        catch (SVNException e) {
            SVNErrorCode err = e.getErrorMessage().getErrorCode();
            if (!(failWhenDstExists || sources.length != 1 || err != SVNErrorCode.ENTRY_EXISTS && err != SVNErrorCode.FS_ALREADY_EXISTS)) {
                SVNCopySource source2 = sources[0];
                String baseName = source2.getName();
                if (source2.isURL()) {
                    baseName = SVNEncodingUtil.uriDecode(baseName);
                }
                this.setupCopy(sources, new SVNPath(new File(dst, baseName).getAbsolutePath(), false, false), isMove, makeParents, pinExternals, externalsToPin, null, null, this.getCommitHandler(), this.getCommitParameters(), this.getExternalsHandler());
                return;
            }
            throw e;
        }
    }

    public SVNCommitInfo doCopy(SVNCopySource[] sources, SVNURL dst, boolean isMove, boolean makeParents, boolean failWhenDstExists, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        return this.doCopy(sources, dst, isMove, makeParents, failWhenDstExists, false, null, commitMessage, revisionProperties);
    }

    public SVNCommitInfo doCopy(SVNCopySource[] sources, SVNURL dst, boolean isMove, boolean makeParents, boolean failWhenDstExists, boolean pinExternals, Map<SvnTarget, List<SVNExternal>> externalsToPin, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        if (sources.length > 1 && failWhenDstExists) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MULTIPLE_SOURCES_DISALLOWED);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if ((sources = this.expandCopySources(sources)).length == 0) {
            return SVNCommitInfo.NULL;
        }
        try {
            return this.setupCopy(sources, new SVNPath(dst.toString(), false, false), isMove, makeParents, pinExternals, externalsToPin, commitMessage, revisionProperties, this.getCommitHandler(), this.getCommitParameters(), this.getExternalsHandler());
        }
        catch (SVNException e) {
            SVNErrorCode err = e.getErrorMessage().getErrorCode();
            if (!(failWhenDstExists || sources.length != 1 || err != SVNErrorCode.ENTRY_EXISTS && err != SVNErrorCode.FS_ALREADY_EXISTS)) {
                SVNCopySource source2 = sources[0];
                String baseName = source2.getName();
                if (!source2.isURL()) {
                    baseName = SVNEncodingUtil.uriEncode(baseName);
                }
                return this.setupCopy(sources, new SVNPath(dst.appendPath(baseName, true).toString(), false, false), isMove, makeParents, pinExternals, externalsToPin, commitMessage, revisionProperties, this.getCommitHandler(), this.getCommitParameters(), this.getExternalsHandler());
            }
            throw e;
        }
    }

    public void doCopy(File nestedWC) throws SVNException {
        this.copyDisjointWCToWC(nestedWC);
    }
}

