/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnSetWCDbVersion
extends SvnOperation<Void> {
    public static final int WC_DB_17_VERSION = 29;
    public static final int WC_DB_18_VERSION = 31;
    private int version;

    protected SvnSetWCDbVersion(SvnOperationFactory factory2) {
        super(factory2);
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void run() throws SVNException {
        for (SvnTarget target : this.getTargets()) {
            File wc;
            File wcDb;
            if (!target.isFile() || SVNFileType.getType(wcDb = new File(wc = this.getFirstTarget().getFile(), SVNFileUtil.getAdminDirectoryName() + "/wc.db")) != SVNFileType.FILE) continue;
            SVNSqlJetDb db = SVNSqlJetDb.open(wcDb, SVNSqlJetDb.Mode.ReadWrite);
            db.beginTransaction(SqlJetTransactionMode.WRITE);
            try {
                SvnNgUpgradeSDb.setVersion(db, this.getVersion());
            }
            finally {
                db.commit();
            }
        }
        return null;
    }

    @Override
    protected void initDefaults() {
        super.initDefaults();
        this.setVersion(31);
    }

    @Override
    protected void ensureArgumentsAreValid() throws SVNException {
        super.ensureArgumentsAreValid();
        if (this.getVersion() != 29 && this.getVersion() != 31) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "wc.db version could only be {1} or {2}.", new Object[]{29, 31});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }
}

