/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

public class TokenLocation {
    private final int startLine;
    private final int startLineOffset;
    private final int endLine;
    private final int endLineOffset;

    public TokenLocation(int line, int column, String value) {
        this.startLine = line;
        this.startLineOffset = column;
        String[] lines = value.split("\r\n|\n|\r", -1);
        if (lines.length > 1) {
            this.endLine = line + lines.length - 1;
            this.endLineOffset = lines[lines.length - 1].length();
        } else {
            this.endLine = this.startLine;
            this.endLineOffset = this.startLineOffset + value.length();
        }
    }

    public int startLine() {
        return this.startLine;
    }

    public int startLineOffset() {
        return this.startLineOffset;
    }

    public int endLine() {
        return this.endLine;
    }

    public int endLineOffset() {
        return this.endLineOffset;
    }
}

