/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.comments;

import java.util.Iterator;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.CommentNode;
import org.sonar.plugins.html.node.Node;

@Rule(key="AvoidHtmlCommentCheck")
public class AvoidHtmlCommentCheck
extends AbstractPageCheck {
    private boolean isServerSidePage;

    @Override
    public void comment(CommentNode node) {
        String comment = node.getCode();
        if (this.isServerSidePage && node.isHtml() && !comment.startsWith("<!--[if")) {
            this.createViolation(node.getStartLinePosition(), "Make sure that the HTML comment does not contain sensitive information.");
        }
    }

    @Override
    public void startDocument(List<Node> nodes) {
        this.isServerSidePage = false;
        Iterator<Node> iterator = nodes.iterator();
        while (!this.isServerSidePage && iterator.hasNext()) {
            String code = iterator.next().getCode();
            if (!code.startsWith("<?php") && !code.startsWith("<%")) continue;
            this.isServerSidePage = true;
        }
    }
}

