/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.DirectiveNode;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="DoctypePresenceCheck")
public class DoctypePresenceCheck
extends AbstractPageCheck {
    private boolean foundDoctype;
    private boolean reported;

    @Override
    public void startDocument(List<Node> nodes) {
        this.foundDoctype = false;
        this.reported = false;
    }

    @Override
    public void directive(DirectiveNode node) {
        if (DoctypePresenceCheck.isDoctype(node)) {
            this.foundDoctype = true;
        }
    }

    private static boolean isDoctype(DirectiveNode node) {
        return "DOCTYPE".equalsIgnoreCase(node.getNodeName());
    }

    @Override
    public void startElement(TagNode node) {
        if (DoctypePresenceCheck.isHtml(node) && !this.foundDoctype && !this.reported) {
            this.createViolation(node, "Insert a <!DOCTYPE> declaration to before this <" + node.getNodeName() + "> tag.");
            this.reported = true;
        }
    }

    private static boolean isHtml(TagNode node) {
        return "HTML".equalsIgnoreCase(node.getNodeName());
    }
}

