/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="S5254")
public class LangAttributeCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (LangAttributeCheck.isHtmlTag(node) && !LangAttributeCheck.hasLangAttribute(node)) {
            this.createViolation(node, "Add \"lang\" and/or \"xml:lang\" attributes to this \"<html>\" element");
        }
    }

    private static boolean isHtmlTag(TagNode node) {
        return "HTML".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean hasLangAttribute(TagNode node) {
        return node.hasProperty("lang") || node.hasProperty("xml:lang");
    }
}

