/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="S5260")
public class TableHeaderReferenceCheck
extends AbstractPageCheck {
    private static final Table.Cell NIL = new Table.Cell(null);
    private static final Pattern DYNAMIC_HEADERS = Pattern.compile("[{}$()\\[\\]]");
    private static final String HEADERS = "HEADERS";
    private Deque<TableBuilder> stack = new LinkedList<TableBuilder>();

    @Override
    public void startDocument(List<Node> nodes) {
        this.stack.clear();
    }

    @Override
    public void startElement(TagNode node) {
        if (TableHeaderReferenceCheck.isTable(node)) {
            this.stack.push(new TableBuilder());
        } else if (!this.stack.isEmpty()) {
            if (TableHeaderReferenceCheck.isTableRow(node)) {
                this.stack.peek().newRow();
            } else if (TableHeaderReferenceCheck.isTableData(node)) {
                this.stack.peek().newCell(new Table.Cell(node));
            } else if (TableHeaderReferenceCheck.isTableHeader(node)) {
                this.stack.peek().newCell(new Table.Header(node));
            }
        }
    }

    @Override
    public void endElement(TagNode node) {
        if (TableHeaderReferenceCheck.isTable(node) && !this.stack.isEmpty()) {
            this.raiseViolationOnInvalidReference(this.stack.pop().build());
        }
    }

    private void raiseViolationOnInvalidReference(Table table) {
        Map<TagNode, List<String>> referenceableHeaders = table.findReferenceableHeadersPerCellNode();
        HashMap raisedFor = new HashMap();
        table.forEachCell((cell, row, column) -> {
            TagNode node = cell.node();
            List<String> actual = cell.headers();
            List expected = referenceableHeaders.getOrDefault(node, Collections.emptyList());
            for (String header : actual) {
                if (expected.contains(header) || raisedFor.getOrDefault(node, Collections.emptyList()).contains(header)) continue;
                if (TableHeaderReferenceCheck.isExistingHeader(table, header)) {
                    this.createViolation(node, String.format("id \"%s\" in \"headers\" reference the header of another column/row.", header));
                } else {
                    this.createViolation(node, String.format("id \"%s\" in \"headers\" does not reference any <th> header.", header));
                }
                raisedFor.merge(node, Arrays.asList(header), (acc, val) -> {
                    acc.addAll(val);
                    return acc;
                });
                break;
            }
        });
    }

    private static boolean isExistingHeader(Table table, String headerName) {
        return table.rows().stream().flatMap(Collection::stream).filter(cell -> cell instanceof Table.Header).map(cell -> (Table.Header)cell).anyMatch(header -> headerName.equalsIgnoreCase(header.id()));
    }

    private static boolean isTable(TagNode node) {
        return node.equalsElementName("TABLE");
    }

    private static boolean isTableRow(TagNode node) {
        return node.equalsElementName("TR");
    }

    private static boolean isTableData(TagNode node) {
        return node.equalsElementName("TD");
    }

    private static boolean isTableHeader(TagNode node) {
        return node.equalsElementName("TH");
    }

    private static class TableBuilder {
        private ArrayList<RowBuilder> rows = new ArrayList();
        private RowBuilder currentRow = null;

        private TableBuilder() {
        }

        void newRow() {
            int indexOfCurrentRow = this.rows.indexOf(this.currentRow);
            if (indexOfCurrentRow == this.rows.size() - 1) {
                this.currentRow = new RowBuilder();
                this.rows.add(this.currentRow);
            } else {
                this.currentRow = this.rows.get(this.rows.indexOf(this.currentRow) + 1);
            }
        }

        void newCell(Table.Cell cell) {
            if (this.rows.isEmpty()) {
                return;
            }
            int rowspan = TableBuilder.getRowSpan(cell.node());
            int rowStart = this.rows.indexOf(this.currentRow);
            int rowEnd = rowStart + rowspan;
            int colspan = TableBuilder.getColSpan(cell.node());
            int cellStart = this.rows.get(rowStart).indexOfVacantCell();
            if (cellStart == -1) {
                cellStart = this.rows.get(rowStart).size();
            }
            int cellEnd = cellStart + colspan;
            for (int row = rowStart; row < rowEnd; ++row) {
                if (row == this.rows.size()) {
                    this.rows.add(new RowBuilder());
                }
                for (int col = cellStart; col < cellEnd; ++col) {
                    if (col < this.rows.get(row).size()) {
                        this.rows.get(row).set(col, cell);
                        continue;
                    }
                    for (int i = this.rows.get(row).size(); i < col; ++i) {
                        this.rows.get(row).add(NIL);
                    }
                    this.rows.get(row).add(cell);
                }
            }
        }

        Table build() {
            return new Table(this.rows.stream().map(RowBuilder::build).collect(Collectors.toList()));
        }

        private static int getRowSpan(TagNode node) {
            String rowspan = node.getPropertyValue("ROWSPAN");
            try {
                return Integer.parseInt(rowspan);
            }
            catch (NumberFormatException ex) {
                return 1;
            }
        }

        private static int getColSpan(TagNode node) {
            String rowspan = node.getPropertyValue("COLSPAN");
            try {
                return Integer.parseInt(rowspan);
            }
            catch (NumberFormatException ex) {
                return 1;
            }
        }

        private static class RowBuilder {
            private List<Table.Cell> cells = new ArrayList<Table.Cell>();

            private RowBuilder() {
            }

            int indexOfVacantCell() {
                for (int i = 0; i < this.cells.size(); ++i) {
                    if (this.cells.get(i) != NIL) continue;
                    return i;
                }
                return -1;
            }

            List<Table.Cell> build() {
                return Collections.unmodifiableList(this.cells);
            }

            void set(int cellIndex, Table.Cell cell) {
                this.cells.set(cellIndex, cell);
            }

            int size() {
                return this.cells.size();
            }

            void add(Table.Cell cell) {
                this.cells.add(cell);
            }
        }
    }

    private static class Table {
        private final List<List<Cell>> rows;

        Table(List<List<Cell>> rows) {
            this.rows = Collections.unmodifiableList(rows);
        }

        List<List<Cell>> rows() {
            return this.rows;
        }

        int numberOfCells() {
            int max = 0;
            for (int i = 0; i < this.rows.size(); ++i) {
                max = Integer.max(max, this.rows.get(i).size());
            }
            return max;
        }

        int numberOfRows() {
            return this.rows.size();
        }

        void forEachCell(TriFunction<Cell, Integer, Integer> action) {
            for (int row = 0; row < this.rows.size(); ++row) {
                for (int column = 0; column < this.rows.get(row).size(); ++column) {
                    Cell cell = this.rows.get(row).get(column);
                    if (cell == NIL) continue;
                    action.apply(cell, row, column);
                }
            }
        }

        List<Set<String>> findHorizontalHeaders() {
            ArrayList<Set<String>> headers = new ArrayList<Set<String>>();
            for (int i = 0; i < this.numberOfCells(); ++i) {
                headers.add(new HashSet());
            }
            this.forEachCell((cell, row, column) -> {
                if (cell instanceof Header) {
                    Header header = (Header)cell;
                    ((Set)headers.get((int)column)).add(header.id());
                }
            });
            return headers;
        }

        List<Set<String>> findVerticalHeaders() {
            ArrayList<Set<String>> headers = new ArrayList<Set<String>>();
            for (int i = 0; i < this.numberOfRows(); ++i) {
                headers.add(new HashSet());
            }
            this.forEachCell((cell, row, column) -> {
                if (cell instanceof Header) {
                    Header header = (Header)cell;
                    ((Set)headers.get((int)row)).add(header.id());
                }
            });
            return headers;
        }

        Map<TagNode, List<String>> findReferenceableHeadersPerCellNode() {
            List<Set<String>> horizontalHeaders = this.findHorizontalHeaders();
            List<Set<String>> verticalHeaders = this.findVerticalHeaders();
            HashMap<TagNode, List<String>> referenceable = new HashMap<TagNode, List<String>>();
            this.forEachCell((cell, row, column) -> {
                if (!cell.headers().isEmpty()) {
                    ArrayList headers = new ArrayList();
                    headers.addAll((Collection)horizontalHeaders.get((int)column));
                    headers.addAll((Collection)verticalHeaders.get((int)row));
                    referenceable.merge(cell.node(), headers, (acc, val) -> {
                        acc.addAll(val);
                        return acc;
                    });
                }
            });
            return referenceable;
        }

        private static class Header
        extends Cell {
            private String id;

            Header(TagNode node) {
                super(node);
                this.id = node.getPropertyValue("ID");
            }

            String id() {
                return this.id;
            }
        }

        private static class Cell {
            private final TagNode node;

            Cell(TagNode node) {
                this.node = node;
            }

            TagNode node() {
                return this.node;
            }

            List<String> headers() {
                if (this.node.hasProperty(TableHeaderReferenceCheck.HEADERS) && !DYNAMIC_HEADERS.matcher(this.node.getPropertyValue(TableHeaderReferenceCheck.HEADERS)).find()) {
                    return Arrays.stream(this.node.getPropertyValue(TableHeaderReferenceCheck.HEADERS).split("\\s+")).filter(header -> !header.isEmpty()).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }
        }
    }

    @FunctionalInterface
    private static interface TriFunction<A, B, C> {
        public void apply(A var1, B var2, C var3);
    }
}

