/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.rules;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.plugins.html.rules.CheckClasses;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;

public final class HtmlRulesDefinition
implements RulesDefinition {
    public static final String REPOSITORY_KEY = "Web";
    public static final String REPOSITORY_NAME = "SonarAnalyzer";
    private static final Set<String> TEMPLATE_RULE_KEYS = Collections.unmodifiableSet(Stream.of("IllegalAttributeCheck", "LibraryDependencyCheck", "ChildElementIllegalCheck", "ChildElementRequiredCheck", "ParentElementIllegalCheck", "ParentElementRequiredCheck").collect(Collectors.toSet()));
    public static final String RESOURCE_BASE_PATH = "org/sonar/l10n/web/rules/Web";

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository(REPOSITORY_KEY, "web").setName(REPOSITORY_NAME);
        RuleMetadataLoader ruleMetadataLoader = new RuleMetadataLoader(RESOURCE_BASE_PATH, "org/sonar/l10n/web/rules/Web/Sonar_way_profile.json");
        ruleMetadataLoader.addRulesByAnnotatedClass(repository, CheckClasses.getCheckClasses());
        for (RulesDefinition.NewRule rule : repository.rules()) {
            if (!TEMPLATE_RULE_KEYS.contains(rule.key())) continue;
            rule.setTemplate(true);
        }
        repository.done();
    }
}

